unit xcb_events_bindings;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}
{$PACKRECORDS C}

interface

uses
  ctypes, xcb_const, xcb_bindings, xproto_bindings, xcb_more_bindings;

type
  // Additional types
  xcb_timestamp_t = uint32_t;

  // Event structures
  Pxcb_expose_event_t = ^xcb_expose_event_t;
  xcb_expose_event_t = record
    response_type: uint8_t;
    pad0: uint8_t;
    sequence: uint16_t;
    window: xcb_window_t;
    x: uint16_t;
    y: uint16_t;
    width: uint16_t;
    height: uint16_t;
    count: uint16_t;
    pad1: array[0..1] of uint8_t;
  end;

  Pxcb_button_press_event_t = ^xcb_button_press_event_t;
  xcb_button_press_event_t = record
    response_type: uint8_t;
    detail: uint8_t;
    sequence: uint16_t;
    time: xcb_timestamp_t;
    root: xcb_window_t;
    event: xcb_window_t;
    child: xcb_window_t;
    root_x: int16_t;
    root_y: int16_t;
    event_x: int16_t;
    event_y: int16_t;
    state: uint16_t;
    same_screen: uint8_t;
    pad0: uint8_t;
  end;

  Pxcb_button_release_event_t = ^xcb_button_release_event_t;
  xcb_button_release_event_t = xcb_button_press_event_t;

  Pxcb_motion_notify_event_t = ^xcb_motion_notify_event_t;
  xcb_motion_notify_event_t = record
    response_type: uint8_t;
    detail: uint8_t;
    sequence: uint16_t;
    time: xcb_timestamp_t;
    root: xcb_window_t;
    event: xcb_window_t;
    child: xcb_window_t;
    root_x: int16_t;
    root_y: int16_t;
    event_x: int16_t;
    event_y: int16_t;
    state: uint16_t;
    same_screen: uint8_t;
    pad0: uint8_t;
  end;

  Pxcb_enter_notify_event_t = ^xcb_enter_notify_event_t;
  xcb_enter_notify_event_t = record
    response_type: uint8_t;
    detail: uint8_t;
    sequence: uint16_t;
    time: xcb_timestamp_t;
    root: xcb_window_t;
    event: xcb_window_t;
    child: xcb_window_t;
    root_x: int16_t;
    root_y: int16_t;
    event_x: int16_t;
    event_y: int16_t;
    state: uint16_t;
    mode: uint8_t;
    same_screen_focus: uint8_t;
  end;

  Pxcb_leave_notify_event_t = ^xcb_leave_notify_event_t;
  xcb_leave_notify_event_t = xcb_enter_notify_event_t;

  Pxcb_key_press_event_t = ^xcb_key_press_event_t;
  xcb_key_press_event_t = record
    response_type: uint8_t;
    detail: uint8_t;
    sequence: uint16_t;
    time: xcb_timestamp_t;
    root: xcb_window_t;
    event: xcb_window_t;
    child: xcb_window_t;
    root_x: int16_t;
    root_y: int16_t;
    event_x: int16_t;
    event_y: int16_t;
    state: uint16_t;
    same_screen: uint8_t;
    pad0: uint8_t;
  end;

  Pxcb_key_release_event_t = ^xcb_key_release_event_t;
  xcb_key_release_event_t = xcb_key_press_event_t;

  // Универсальное объединение для данных ClientMessage
  xcb_client_message_data_t = record
    case Integer of
      0: (data8: array[0..19] of cuint8);
      1: (data16: array[0..9] of cuint16);
      2: (data32: array[0..4] of cuint32);
  end;

  // Структура события ClientMessage
  xcb_client_message_event_t = record
    response_type : cuint8;
    format        : cuint8;
    sequence      : cuint16;
    window        : xcb_window_t;
    _type    : xcb_atom_t;     // "type" в C
    data          : xcb_client_message_data_t;
  end;

  Pxcb_client_message_event_t = ^xcb_client_message_event_t;

{
const
  // Mouse button details
  XCB_BUTTON_INDEX_1 = 1;
  XCB_BUTTON_INDEX_2 = 2;
  XCB_BUTTON_INDEX_3 = 3;
  XCB_BUTTON_INDEX_4 = 4;
  XCB_BUTTON_INDEX_5 = 5;

  // Modifier masks
  XCB_MOD_MASK_SHIFT   = 1 shl 0;
  XCB_MOD_MASK_LOCK    = 1 shl 1;
  XCB_MOD_MASK_CONTROL = 1 shl 2;
  XCB_MOD_MASK_1       = 1 shl 3;
  XCB_MOD_MASK_2       = 1 shl 4;
  XCB_MOD_MASK_3       = 1 shl 5;
  XCB_MOD_MASK_4       = 1 shl 6;
  XCB_MOD_MASK_5       = 1 shl 7;

  // Button masks
  XCB_BUTTON_MASK_1    = 1 shl 8;
  XCB_BUTTON_MASK_2    = 1 shl 9;
  XCB_BUTTON_MASK_3    = 1 shl 10;
  XCB_BUTTON_MASK_4    = 1 shl 11;
  XCB_BUTTON_MASK_5    = 1 shl 12;
}

implementation

end.