unit xcb_ext_bindings;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}
{$PACKRECORDS C}

interface

uses
  ctypes,xcb_const,xcb_bindings;

type
Puint64_t=PQWord;
Puint8_t=PByte;

  // Protocol request structure
  Pxcb_protocol_request_t = ^xcb_protocol_request_t;
  xcb_protocol_request_t = record
    count: size_t;
    ext: Pxcb_extension_t;
    opcode: uint8_t;
    isvoid: uint8_t;
  end;

  // I/O vector structure for send_request functions
  Piovec = ^iovec;
  iovec = record
    iov_base: Pointer;
    iov_len: size_t;
  end;

{
const
  XCB_REQUEST_CHECKED = 1 shl 0;
  XCB_REQUEST_RAW = 1 shl 1;
  XCB_REQUEST_DISCARD_REPLY = 1 shl 2;
  XCB_REQUEST_REPLY_FDS = 1 shl 3;
}

// Extended request functions
function xcb_send_request(c: Pxcb_connection_t; flags: cint; vector: Piovec; request: Pxcb_protocol_request_t): cuint; cdecl; external libxcb;
function xcb_send_request64(c: Pxcb_connection_t; flags: cint; vector: Piovec; request: Pxcb_protocol_request_t): uint64_t; cdecl; external libxcb;
function xcb_send_request_with_fds(c: Pxcb_connection_t; flags: cint; vector: Piovec; request: Pxcb_protocol_request_t; num_fds: cuint; fds: Pcint): cuint; cdecl; external libxcb;
function xcb_send_request_with_fds64(c: Pxcb_connection_t; flags: cint; vector: Piovec; request: Pxcb_protocol_request_t; num_fds: cuint; fds: Pcint): uint64_t; cdecl; external libxcb;

// Socket control
function xcb_take_socket(c: Pxcb_connection_t; return_socket: Pointer; closure: Pointer; flags: cint; sent: Puint64_t): cint; cdecl; external libxcb;
function xcb_writev(c: Pxcb_connection_t; vector: Piovec; count: cint; requests: uint64_t): cint; cdecl; external libxcb;
procedure xcb_send_fd(c: Pxcb_connection_t; fd: cint); cdecl; external libxcb;

// File descriptor handling
function xcb_get_reply_fds(c: Pxcb_connection_t; reply: Pointer; replylen: size_t): Pcint; cdecl; external libxcb;

// Utility functions
function xcb_popcount(mask: uint32_t): cint; cdecl; external libxcb;
function xcb_sumof(list: Puint8_t; len: cint): cint; cdecl; external libxcb;

implementation

end.