unit xproto_bindings;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}
{$PACKRECORDS C}

interface

uses
  ctypes,xcb_const,xcb_bindings;

type
int16_t=cint16;

  // Basic types from xproto
  xcb_window_t = uint32_t;
  xcb_colormap_t = uint32_t;
  xcb_visualid_t = uint32_t;

  // Screen structure
  Pxcb_screen_t = ^xcb_screen_t;
  xcb_screen_t = record
    root: xcb_window_t;
    default_colormap: xcb_colormap_t;
    white_pixel: uint32_t;
    black_pixel: uint32_t;
    current_input_masks: uint32_t;
    width_in_pixels: uint16_t;
    height_in_pixels: uint16_t;
    width_in_millimeters: uint16_t;
    height_in_millimeters: uint16_t;
    min_installed_maps: uint16_t;
    max_installed_maps: uint16_t;
    root_visual: xcb_visualid_t;
    backing_stores: uint8_t;
    save_unders: uint8_t;
    root_depth: uint8_t;
    allowed_depths_len: uint8_t;
  end;

  // Screen iterator
  Pxcb_screen_iterator_t = ^xcb_screen_iterator_t;
  xcb_screen_iterator_t = record
    data: Pxcb_screen_t;
    rem: cint;
    index: cint;
  end;

{
const
  XCB_WINDOW_CLASS_COPY_FROM_PARENT = 0;
  XCB_WINDOW_CLASS_INPUT_OUTPUT = 1;
  XCB_WINDOW_CLASS_INPUT_ONLY = 2;

  XCB_CW_BACK_PIXMAP = 1 shl 0;
  XCB_CW_BACK_PIXEL = 1 shl 1;
  XCB_CW_BORDER_PIXMAP = 1 shl 2;
  XCB_CW_BORDER_PIXEL = 1 shl 3;
  XCB_CW_BIT_GRAVITY = 1 shl 4;
  XCB_CW_WIN_GRAVITY = 1 shl 5;
  XCB_CW_BACKING_STORE = 1 shl 6;
  XCB_CW_BACKING_PLANES = 1 shl 7;
  XCB_CW_BACKING_PIXEL = 1 shl 8;
  XCB_CW_OVERRIDE_REDIRECT = 1 shl 9;
  XCB_CW_SAVE_UNDER = 1 shl 10;
  XCB_CW_EVENT_MASK = 1 shl 11;
  XCB_CW_DONT_PROPAGATE = 1 shl 12;
  XCB_CW_COLORMAP = 1 shl 13;
  XCB_CW_CURSOR = 1 shl 14;

  // Event masks
  XCB_EVENT_MASK_NO_EVENT = 0;
  XCB_EVENT_MASK_KEY_PRESS = 1 shl 0;
  XCB_EVENT_MASK_KEY_RELEASE = 1 shl 1;
  XCB_EVENT_MASK_BUTTON_PRESS = 1 shl 2;
  XCB_EVENT_MASK_BUTTON_RELEASE = 1 shl 3;
  XCB_EVENT_MASK_ENTER_WINDOW = 1 shl 4;
  XCB_EVENT_MASK_LEAVE_WINDOW = 1 shl 5;
  XCB_EVENT_MASK_POINTER_MOTION = 1 shl 6;
  XCB_EVENT_MASK_POINTER_MOTION_HINT = 1 shl 7;
  XCB_EVENT_MASK_BUTTON_1_MOTION = 1 shl 8;
  XCB_EVENT_MASK_BUTTON_2_MOTION = 1 shl 9;
  XCB_EVENT_MASK_BUTTON_3_MOTION = 1 shl 10;
  XCB_EVENT_MASK_BUTTON_4_MOTION = 1 shl 11;
  XCB_EVENT_MASK_BUTTON_5_MOTION = 1 shl 12;
  XCB_EVENT_MASK_BUTTON_MOTION = 1 shl 13;
  XCB_EVENT_MASK_KEYMAP_STATE = 1 shl 14;
  XCB_EVENT_MASK_EXPOSURE = 1 shl 15;
  XCB_EVENT_MASK_VISIBILITY_CHANGE = 1 shl 16;
  XCB_EVENT_MASK_STRUCTURE_NOTIFY = 1 shl 17;
  XCB_EVENT_MASK_RESIZE_REDIRECT = 1 shl 18;
  XCB_EVENT_MASK_SUBSTRUCTURE_NOTIFY = 1 shl 19;
  XCB_EVENT_MASK_SUBSTRUCTURE_REDIRECT = 1 shl 20;
  XCB_EVENT_MASK_FOCUS_CHANGE = 1 shl 21;
  XCB_EVENT_MASK_PROPERTY_CHANGE = 1 shl 22;
  XCB_EVENT_MASK_COLOR_MAP_CHANGE = 1 shl 23;
  XCB_EVENT_MASK_OWNER_GRAB_BUTTON = 1 shl 24;
}

// Screen iterator functions
function xcb_setup_roots_iterator(setup: Pxcb_setup_t): xcb_screen_iterator_t; cdecl; external libxcb;
procedure xcb_screen_next(iter: Pxcb_screen_iterator_t); cdecl; external libxcb;

// Window functions
function xcb_create_window(connection: Pxcb_connection_t; depth: uint8_t; window, parent: xcb_window_t;
 x, y, width, height: int16_t; border_width, _class: uint16_t; visual: xcb_visualid_t;
 value_mask: uint32_t; value_list: Pointer): xcb_void_cookie_t; cdecl; external libxcb;
function xcb_create_window_checked(connection: Pxcb_connection_t; depth: uint8_t; window, parent: xcb_window_t;
 x, y, width, height: int16_t; border_width, _class: uint16_t; visual: xcb_visualid_t;
 value_mask: uint32_t; value_list: Pointer): xcb_void_cookie_t; cdecl; external libxcb;
function xcb_destroy_window(connection: Pxcb_connection_t; window: xcb_window_t): xcb_void_cookie_t; cdecl; external libxcb;
function xcb_destroy_window_checked(conn: Pxcb_connection_t; window: xcb_window_t): xcb_void_cookie_t; cdecl; external libxcb;
function xcb_map_window(connection: Pxcb_connection_t; window: xcb_window_t): xcb_void_cookie_t; cdecl; external libxcb;
function xcb_map_window_checked(conn: Pxcb_connection_t; window: xcb_window_t): xcb_void_cookie_t; cdecl; external libxcb;
function xcb_unmap_window(conn: Pxcb_connection_t; window: xcb_window_t): xcb_void_cookie_t; cdecl; external libxcb;
function xcb_unmap_window_checked(conn: Pxcb_connection_t; window: xcb_window_t): xcb_void_cookie_t; cdecl; external libxcb;

implementation

end.