program simple_test_xcb;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}

uses
  ctypes, xcb_bindings;

var
  conn: Pxcb_connection_t;
  setup: Pxcb_setup_t;
  screen_iter: Txcb_screen_iterator_t;
  screen: Pxcb_screen_t;

begin
  WriteLn('Simple XCB connection test...');

  // Connect to X server
  conn := xcb_connect(nil, nil);
  if xcb_connection_has_error(conn) <> 0 then
  begin
    WriteLn('Error: Cannot connect to X server');
    Halt(1);
  end;
  WriteLn('Successfully connected to X server');

  // Get setup information
  setup := xcb_get_setup(conn);
  WriteLn('XCB setup:');
  WriteLn('  Protocol major: ', setup^.protocol_major_version);
  WriteLn('  Protocol minor: ', setup^.protocol_minor_version);
  WriteLn('  Release number: ', setup^.release_number);
  WriteLn('  Resource ID base: ', setup^.resource_id_base);

  // List screens
  screen_iter := xcb_setup_roots_iterator(setup);
  while screen_iter.rem > 0 do
  begin
    screen := screen_iter.data;
    WriteLn('Screen ', (screen_iter.index + 1), ':');
    WriteLn('  Width: ', screen^.width_in_pixels);
    WriteLn('  Height: ', screen^.height_in_pixels);
    WriteLn('  Root window: ', screen^.root);
    xcb_screen_next(@screen_iter);
  end;

  // Disconnect
  xcb_disconnect(conn);
  WriteLn('Disconnected from X server');
  WriteLn('Test completed successfully!');
end.