program test_randr;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}

uses
  xcb, xproto, randr, ctypes;

var
  conn: Pxcb_connection_t;
  screen: Pxcb_screen_t;
  version_cookie: Txcb_randr_query_version_cookie_t;
  version_reply: Pxcb_randr_query_version_reply_t;

begin
  WriteLn('Testing RANDR extension...');

  conn := xcb_connect(nil, nil);
  if xcb_connection_has_error(conn) <> 0 then
  begin
    WriteLn('Error: Cannot connect to X server');
    Halt(1);
  end;

  screen := xcb_setup_roots_iterator(xcb_get_setup(conn)).data;

  // Query RANDR version
  version_cookie := xcb_randr_query_version(conn, 1, 2);
  version_reply := xcb_randr_query_version_reply(conn, version_cookie, nil);

  if version_reply <> nil then
  begin
    WriteLn('RANDR version: ', version_reply^.major_version, '.', version_reply^.minor_version);
    FreeMem(version_reply);
  end
  else
  begin
    WriteLn('RANDR extension not available');
  end;

  xcb_disconnect(conn);
  WriteLn('RANDR test completed');
end.