program test_window_geometry;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}

uses
  ctypes, xcb_bindings;

var
  conn: Pxcb_connection_t;
  screen: Pxcb_screen_t;
  window: cuint32;
  geom_cookie: Txcb_get_geometry_cookie_t;
  geom_reply: Pxcb_get_geometry_reply_t;
  error: Pxcb_generic_error_t;

begin
  WriteLn('Testing XCB window geometry...');

  // Connect to X server
  conn := xcb_connect(nil, nil);
  if xcb_connection_has_error(conn) <> 0 then
  begin
    WriteLn('Error: Cannot connect to X server');
    Halt(1);
  end;

  // Get first screen
  screen := xcb_setup_roots_iterator(xcb_get_setup(conn)).data;
  
  // Create window
  window := xcb_generate_id(conn);
  
  xcb_create_window(
    conn,
    XCB_COPY_FROM_PARENT,
    window,
    screen^.root,
    200, 200,  // x, y
    300, 200,  // width, height
    5,         // border width
    XCB_WINDOW_CLASS_INPUT_OUTPUT,
    screen^.root_visual,
    0, nil
  );

  xcb_map_window(conn, window);
  xcb_flush(conn);

  // Get window geometry
  WriteLn('Getting window geometry...');
  geom_cookie := xcb_get_geometry(conn, window);
  geom_reply := xcb_get_geometry_reply(conn, geom_cookie, @error);

  if geom_reply <> nil then
  begin
    WriteLn('Window geometry:');
    WriteLn('  Position: ', geom_reply^.x, 'x', geom_reply^.y);
    WriteLn('  Size: ', geom_reply^.width, 'x', geom_reply^.height);
    WriteLn('  Border: ', geom_reply^.border_width);
    WriteLn('  Depth: ', geom_reply^.depth);
    WriteLn('  Root: ', geom_reply^.root);
    FreeMem(geom_reply);
  end
  else if error <> nil then
  begin
    WriteLn('Error getting geometry: ', error^.error_code);
    FreeMem(error);
  end;

  // Cleanup
  xcb_destroy_window(conn, window);
  xcb_disconnect(conn);
  
  WriteLn('Geometry test completed!');
end.