unit xcb;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}

interface

uses
  ctypes;

type
  // Basic XCB types
  Txcb_connection_t = Pointer;
  Txcb_window_t = cuint32;
  Txcb_pixmap_t = cuint32;
  Txcb_cursor_t = cuint32;
  Txcb_font_t = cuint32;
  Txcb_gcontext_t = cuint32;
  Txcb_colormap_t = cuint32;
  Txcb_atom_t = cuint32;
  Txcb_drawable_t = cuint32;
  Txcb_fontable_t = cuint32;
  Txcb_bool_t = cuint8;
  Txcb_char2b_t = packed record
    byte1: cuint8;
    byte2: cuint8;
  end;

  // Common types used across modules
  TTimestamp = cuint32;
  TKeyCode = cuint8;
  TKeySym = cuint32;
  TSync = cuint32;
  TGLX = cuint32;
  TBehavior = cuint32;
  Tglx_DRAWABLE = cuint32;
  
  // Add all the missing types that are causing errors
  TWINDOW = cuint32;
  TDAMAGE = cuint32;
  TBackBuffer = cuint32;
  TBufferAttributes = cuint32;
  TBOOL32 = cuint32;
  TFLOAT32 = cfloat;
  TFLOAT64 = cdouble;
  TCONTEXT_TAG = cuint32;
  TEVENT = cuint32;
  TMODE = cuint32;
  TOUTPUT = cuint32;
  TPROVIDER = cuint32;
  TLEASE = cuint32;
  TCrtcChange = cuint32;
  TOutputChange = cuint32;
  TOutputProperty = cuint32;
  TProviderChange = cuint32;
  TProviderProperty = cuint32;
  TResourceChange = cuint32;
  TLeaseNotify = cuint32;
  TNotifyData = cuint32;
  TRange8 = cuint8;
  TRange16 = cuint16;
  TExtRange = cuint32;
  TClientSpec = cuint32;
  TElementHeader = cuint32;
  TPICTFORMAT = cuint32;
  TDIRECTFORMAT = cuint32;
  TFIXED = cuint32;
  TPOINTFIX = cuint32;
  TLINEFIX = cuint32;
  TCOUNTER = cuint32;
  Tsync_INT64 = cuint64;
  TTRIGGER = cuint32;
  TALARM = cuint32;
  TClientIdSpec = cuint32;
  TResourceIdSpec = cuint32;
  TResourceSizeSpec = cuint32;
  TKIND = cuint32;
  TSEG = cuint32;
  TDOTCLOCK = cuint32;
  TEventTypeBase = cuint32;
  TDeviceId = cuint32;
  TFP3232 = cuint32;
  TDefaultBehavior = cuint32;
  TLockBehavior = cuint32;
  TRadioGroupBehavior = cuint32;
  TOverlayBehavior = cuint32;
  TSASetMods = cuint32;
  TSASetGroup = cuint32;
  TSASetControls = cuint32;
  TLedClassSpec = cuint32;
  TIDSpec = cuint32;
  TSIAction = cuint32;
  TCommonBehavior = cuint32;
  TPermamentLockBehavior = cuint32;
  TPermamentRadioGroupBehavior = cuint32;
  TPermamentOverlayBehavior = cuint32;
  TSANoAction = cuint32;
  TSALatchMods = cuint32;
  TSALockMods = cuint32;
  TSALatchGroup = cuint32;
  TPCONTEXT = cuint32;
  TSURFACE = cuint32;
  TPORT = cuint32;
  TENCODING = cuint32;
  TRational = cuint32;
  TVISUALID = cuint32;
  TATOM = cuint32;
  TCOLORMAP = cuint32;
  TKeySymMap = cuint32;
  TCRTC = cuint32;
  TPIXMAP = cuint32;

  TTRANSFORM = cuint32;
  TPICTURE = cuint32;
  TGLYPHSET = cuint32;
  TGLYPH = cuint32;
  TFENCE = cuint32;

  TSPANFIX = cuint32;
  TModifierInfo = cuint32;
  TGroupInfo = cuint32;
  TDeviceState = cuint32;
  TSAMovePtr = cuint32;
  TSAPtrBtn = cuint32;
  TSALockPtrBtn = cuint32;
  TSASetPtrDflt = cuint32;
  TSAIsoLock = cuint32;
  TSATerminate = cuint32;
  TSASwitchScreen = cuint32;
  TSAActionMessage = cuint32;
  TSARedirectKey = cuint32;
  TSADeviceBtn = cuint32;
  TSALockDeviceBtn = cuint32;
  TSADeviceValuator = cuint32;
  TCHARINFO = cuint32;
  
  // Структуры, которые могут быть определены позже
  TCHARINFO_Struct = packed record
    left_side_bearing: cint16;
    right_side_bearing: cint16;
    character_width: cint16;
    ascent: cint16;
    descent: cint16;
    attributes: cuint16;
  end;
  
  TRectangle = packed record
    x: cint16;
    y: cint16;
    width: cuint16;
    height: cuint16;
  end;
  PRectangle = ^TRectangle;

  // Common structs
  TClientMessageData = packed record
    data8: array[0..19] of cuint8;
  end;

implementation

end.