unit _record;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from record.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // xidtype CONTEXT
  type TCONTEXT = cuint32;

  // typedef ElementHeader -> CARD8
  type TElementHeader = cuint8;

  // typedef ClientSpec -> CARD32
  type TClientSpec = cuint32;

  // enum HType
  const HType_FromServerTime = 1;
  const HType_FromClientTime = 2;
  const HType_FromClientSequence = 4;

  // enum CS
  const CS_CurrentClients = 1;
  const CS_FutureClients = 2;
  const CS_AllClients = 3;

  // struct Range8
  type
    TRange8_Struct = packed record
      first: cuint8;
      last: cuint8;
    end;

  // struct Range16
  type
    TRange16_Struct = packed record
      first: cuint16;
      last: cuint16;
    end;

  // struct ExtRange
  type
    TExtRange_Struct = packed record
      major: cuint32;
      minor: cuint32;
    end;

  // struct Range
  type
    TRange_Struct = packed record
      core_requests: cuint32;
      core_replies: cuint32;
      ext_requests: cuint32;
      ext_replies: cuint32;
      delivered_events: cuint32;
      device_events: cuint32;
      errors: cuint32;
      client_started: cuint8;
      client_died: cuint8;
    end;

  // struct ClientInfo
  type
    TClientInfo_Struct = packed record
      client_resource: TClientSpec;
      num_ranges: cuint32;
      list_2: Pointer; // list field
    end;

  // error BadContext
  type
    TBadContext_Error = packed record
      invalid_record: cuint32;
    end;

  // request QueryVersion
  const XCB_QUERYVERSION = 0; // opcode
  type
    TQueryVersionReply = packed record
      major_version: cuint16;
      minor_version: cuint16;
    end;

  // request CreateContext
  const XCB_CREATECONTEXT = 1; // opcode
  // request RegisterClients
  const XCB_REGISTERCLIENTS = 2; // opcode
  // request UnregisterClients
  const XCB_UNREGISTERCLIENTS = 3; // opcode
  // request GetContext
  const XCB_GETCONTEXT = 4; // opcode
  type
    TGetContextReply = packed record
      enabled: cuint8;
      element_header: TElementHeader;
      num_intercepted_clients: cuint32;
    end;

  // request EnableContext
  const XCB_ENABLECONTEXT = 5; // opcode
  type
    TEnableContextReply = packed record
      category: cuint8;
      element_header: TElementHeader;
      client_swapped: cuint8;
      xid_base: cuint32;
      server_time: cuint32;
      rec_sequence_num: cuint32;
    end;

  // request DisableContext
  const XCB_DISABLECONTEXT = 6; // opcode
  // request FreeContext
  const XCB_FREECONTEXT = 7; // opcode

implementation

end.
