unit dbe;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from dbe.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // typedef BackBuffer -> DRAWABLE
  type TBackBuffer = cuint32;

  // enum SwapAction
  const SwapAction_Undefined = 0;
  const SwapAction_Background = 1;
  const SwapAction_Untouched = 2;
  const SwapAction_Copied = 3;

  // struct SwapInfo
  type
    TSwapInfo_Struct = packed record
      window: TWINDOW;
      swap_action: cuint8;
      pad_2: array[0..3-1] of cuint8; // padding
    end;

  // struct BufferAttributes
  type
    TBufferAttributes_Struct = packed record
      window: TWINDOW;
    end;

  // struct VisualInfo
  type
    TVisualInfo_Struct = packed record
      visual_id: cuint32;
      depth: cuint8;
      perf_level: cuint8;
      pad_3: array[0..2-1] of cuint8; // padding
    end;

  // struct VisualInfos
  type
    TVisualInfos_Struct = packed record
      n_infos: cuint32;
      list_1: Pointer; // list field
    end;

  // error BadBuffer
  type
    TBadBuffer_Error = packed record
      bad_buffer: TBackBuffer;
    end;

  // request QueryVersion
  const XCB_QUERYVERSION = 0; // opcode
  type
    TQueryVersionReply = packed record
      major_version: cuint8;
      minor_version: cuint8;
    end;

  // request AllocateBackBuffer
  const XCB_ALLOCATEBACKBUFFER = 1; // opcode
  // request DeallocateBackBuffer
  const XCB_DEALLOCATEBACKBUFFER = 2; // opcode
  // request SwapBuffers
  const XCB_SWAPBUFFERS = 3; // opcode
  // request BeginIdiom
  const XCB_BEGINIDIOM = 4; // opcode
  // request EndIdiom
  const XCB_ENDIDIOM = 5; // opcode
  // request GetVisualInfo
  const XCB_GETVISUALINFO = 6; // opcode
  type
    TGetVisualInfoReply = packed record
      n_supported_visuals: cuint32;
    end;

  // request GetBackBufferAttributes
  const XCB_GETBACKBUFFERATTRIBUTES = 7; // opcode
  type
    TGetBackBufferAttributesReply = packed record
      attributes: cuint32;
    end;


implementation

end.
