unit dri2;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from dri2.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // enum Attachment
  const Attachment_BufferFrontLeft = 0;
  const Attachment_BufferBackLeft = 1;
  const Attachment_BufferFrontRight = 2;
  const Attachment_BufferBackRight = 3;
  const Attachment_BufferDepth = 4;
  const Attachment_BufferStencil = 5;
  const Attachment_BufferAccum = 6;
  const Attachment_BufferFakeFrontLeft = 7;
  const Attachment_BufferFakeFrontRight = 8;
  const Attachment_BufferDepthStencil = 9;
  const Attachment_BufferHiz = 10;

  // enum DriverType
  const DriverType_DRI = 0;
  const DriverType_VDPAU = 1;

  // enum EventType
  const EventType_ExchangeComplete = 1;
  const EventType_BlitComplete = 2;
  const EventType_FlipComplete = 3;

  // struct DRI2Buffer
  type
    TDRI2Buffer_Struct = packed record
      attachment: cuint32;
      name: cuint32;
      pitch: cuint32;
      cpp: cuint32;
      flags: cuint32;
    end;

  // struct AttachFormat
  type
    TAttachFormat_Struct = packed record
      attachment: cuint32;
      format: cuint32;
    end;

  // event BufferSwapComplete
  type
    TBufferSwapComplete_Event = packed record
      event_type: cuint16;
      drawable: cuint32;
      ust_hi: cuint32;
      ust_lo: cuint32;
      msc_hi: cuint32;
      msc_lo: cuint32;
      sbc: cuint32;
    end;

  // event InvalidateBuffers
  type
    TInvalidateBuffers_Event = packed record
      drawable: cuint32;
    end;

  // request QueryVersion
  const XCB_QUERYVERSION = 0; // opcode
  type
    TQueryVersionReply = packed record
      major_version: cuint32;
      minor_version: cuint32;
    end;

  // request Connect
  const XCB_CONNECT = 1; // opcode
  type
    TConnectReply = packed record
      driver_name_length: cuint32;
      device_name_length: cuint32;
    end;

  // request Authenticate
  const XCB_AUTHENTICATE = 2; // opcode
  type
    TAuthenticateReply = packed record
      authenticated: cuint32;
    end;

  // request CreateDrawable
  const XCB_CREATEDRAWABLE = 3; // opcode
  // request DestroyDrawable
  const XCB_DESTROYDRAWABLE = 4; // opcode
  // request GetBuffers
  const XCB_GETBUFFERS = 5; // opcode
  type
    TGetBuffersReply = packed record
      width: cuint32;
      height: cuint32;
      count: cuint32;
    end;

  // request CopyRegion
  const XCB_COPYREGION = 6; // opcode
  type
    TCopyRegionReply = packed record
    end;

  // request GetBuffersWithFormat
  const XCB_GETBUFFERSWITHFORMAT = 7; // opcode
  type
    TGetBuffersWithFormatReply = packed record
      width: cuint32;
      height: cuint32;
      count: cuint32;
    end;

  // request SwapBuffers
  const XCB_SWAPBUFFERS = 8; // opcode
  type
    TSwapBuffersReply = packed record
      swap_hi: cuint32;
      swap_lo: cuint32;
    end;

  // request GetMSC
  const XCB_GETMSC = 9; // opcode
  type
    TGetMSCReply = packed record
      ust_hi: cuint32;
      ust_lo: cuint32;
      msc_hi: cuint32;
      msc_lo: cuint32;
      sbc_hi: cuint32;
      sbc_lo: cuint32;
    end;

  // request WaitMSC
  const XCB_WAITMSC = 10; // opcode
  type
    TWaitMSCReply = packed record
      ust_hi: cuint32;
      ust_lo: cuint32;
      msc_hi: cuint32;
      msc_lo: cuint32;
      sbc_hi: cuint32;
      sbc_lo: cuint32;
    end;

  // request WaitSBC
  const XCB_WAITSBC = 11; // opcode
  type
    TWaitSBCReply = packed record
      ust_hi: cuint32;
      ust_lo: cuint32;
      msc_hi: cuint32;
      msc_lo: cuint32;
      sbc_hi: cuint32;
      sbc_lo: cuint32;
    end;

  // request SwapInterval
  const XCB_SWAPINTERVAL = 12; // opcode
  // request GetParam
  const XCB_GETPARAM = 13; // opcode
  type
    TGetParamReply = packed record
      is_param_recognized: cuint8;
      value_hi: cuint32;
      value_lo: cuint32;
    end;


implementation

end.
