unit present;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from present.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // xidtype EVENT
  type TEVENT = cuint32;

  // enum Event
  const Event_ConfigureNotify = 0;
  const Event_CompleteNotify = 1;
  const Event_IdleNotify = 2;
  const Event_RedirectNotify = 3;

  // enum EventMask
  const EventMask_NoEvent = 0;
  const EventMask_ConfigureNotify = 1;
  const EventMask_CompleteNotify = 2;
  const EventMask_IdleNotify = 4;
  const EventMask_RedirectNotify = 8;

  // enum Option
  const Option_None = 0;
  const Option_Async = 1;
  const Option_Copy = 2;
  const Option_UST = 4;
  const Option_Suboptimal = 8;
  const Option_AsyncMayTear = 16;

  // enum Capability
  const Capability_None = 0;
  const Capability_Async = 1;
  const Capability_Fence = 2;
  const Capability_UST = 4;
  const Capability_AsyncMayTear = 8;
  const Capability_Syncobj = 16;

  // enum CompleteKind
  const CompleteKind_Pixmap = 0;
  const CompleteKind_NotifyMSC = 1;

  // enum CompleteMode
  const CompleteMode_Copy = 0;
  const CompleteMode_Flip = 1;
  const CompleteMode_Skip = 2;
  const CompleteMode_SuboptimalCopy = 3;

  // struct Notify
  type
    TNotify_Struct = packed record
      window: TWINDOW;
      serial: cuint32;
    end;

  // event Generic
  type
    TGeneric_Event = packed record
      extension: cuint8;
      length: cuint32;
      evtype: cuint16;
      event: TEVENT;
    end;

  // event ConfigureNotify
  type
    TConfigureNotify_Event = packed record
      event: TEVENT;
      window: TWINDOW;
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
      off_x: cint16;
      off_y: cint16;
      pixmap_width: cuint16;
      pixmap_height: cuint16;
      pixmap_flags: cuint32;
    end;

  // event CompleteNotify
  type
    TCompleteNotify_Event = packed record
      kind: cuint8;
      mode: cuint8;
      event: TEVENT;
      window: TWINDOW;
      serial: cuint32;
      ust: cuint64;
      msc: cuint64;
    end;

  // event IdleNotify
  type
    TIdleNotify_Event = packed record
      event: TEVENT;
      window: TWINDOW;
      serial: cuint32;
      pixmap: TPIXMAP;
      idle_fence: cuint32;
    end;

  // event RedirectNotify
  type
    TRedirectNotify_Event = packed record
      update_window: cuint8;
      event: TEVENT;
      event_window: TWINDOW;
      window: TWINDOW;
      pixmap: TPIXMAP;
      serial: cuint32;
      valid_region: cuint32;
      update_region: cuint32;
      valid_rect: cuint32;
      update_rect: cuint32;
      x_off: cint16;
      y_off: cint16;
      target_crtc: cuint32;
      wait_fence: cuint32;
      idle_fence: cuint32;
      options: cuint32;
      target_msc: cuint64;
      divisor: cuint64;
      remainder: cuint64;
    end;

  // request QueryVersion
  const XCB_QUERYVERSION = 0; // opcode
  type
    TQueryVersionReply = packed record
      major_version: cuint32;
      minor_version: cuint32;
    end;

  // request Pixmap
  const XCB_PIXMAP = 1; // opcode
  // request NotifyMSC
  const XCB_NOTIFYMSC = 2; // opcode
  // request SelectInput
  const XCB_SELECTINPUT = 3; // opcode
  // request QueryCapabilities
  const XCB_QUERYCAPABILITIES = 4; // opcode
  type
    TQueryCapabilitiesReply = packed record
      capabilities: cuint32;
    end;

  // request PixmapSynced
  const XCB_PIXMAPSYNCED = 5; // opcode

implementation

end.
