unit randr;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from randr.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // xidtype MODE
  type TMODE = cuint32;

  // xidtype CRTC
  type TCRTC = cuint32;

  // xidtype OUTPUT
  type TOUTPUT = cuint32;

  // xidtype PROVIDER
  type TPROVIDER = cuint32;

  // xidtype LEASE
  type TLEASE = cuint32;

  // enum Rotation
  const Rotation_Rotate_0 = 1;
  const Rotation_Rotate_90 = 2;
  const Rotation_Rotate_180 = 4;
  const Rotation_Rotate_270 = 8;
  const Rotation_Reflect_X = 16;
  const Rotation_Reflect_Y = 32;

  // enum SetConfig
  const SetConfig_Success = 0;
  const SetConfig_InvalidConfigTime = 1;
  const SetConfig_InvalidTime = 2;
  const SetConfig_Failed = 3;

  // enum NotifyMask
  const NotifyMask_ScreenChange = 1;
  const NotifyMask_CrtcChange = 2;
  const NotifyMask_OutputChange = 4;
  const NotifyMask_OutputProperty = 8;
  const NotifyMask_ProviderChange = 16;
  const NotifyMask_ProviderProperty = 32;
  const NotifyMask_ResourceChange = 64;
  const NotifyMask_Lease = 128;

  // enum ModeFlag
  const ModeFlag_HsyncPositive = 1;
  const ModeFlag_HsyncNegative = 2;
  const ModeFlag_VsyncPositive = 4;
  const ModeFlag_VsyncNegative = 8;
  const ModeFlag_Interlace = 16;
  const ModeFlag_DoubleScan = 32;
  const ModeFlag_Csync = 64;
  const ModeFlag_CsyncPositive = 128;
  const ModeFlag_CsyncNegative = 256;
  const ModeFlag_HskewPresent = 512;
  const ModeFlag_Bcast = 1024;
  const ModeFlag_PixelMultiplex = 2048;
  const ModeFlag_DoubleClock = 4096;
  const ModeFlag_HalveClock = 8192;

  // enum Connection
  const Connection_Connected = 0;
  const Connection_Disconnected = 1;
  const Connection_Unknown = 2;

  // enum Transform
  const Transform_Unit = 1;
  const Transform_ScaleUp = 2;
  const Transform_ScaleDown = 4;
  const Transform_Projective = 8;

  // enum ProviderCapability
  const ProviderCapability_SourceOutput = 1;
  const ProviderCapability_SinkOutput = 2;
  const ProviderCapability_SourceOffload = 4;
  const ProviderCapability_SinkOffload = 8;

  // enum Notify
  const Notify_CrtcChange = 0;
  const Notify_OutputChange = 1;
  const Notify_OutputProperty = 2;
  const Notify_ProviderChange = 3;
  const Notify_ProviderProperty = 4;
  const Notify_ResourceChange = 5;
  const Notify_Lease = 6;

  // struct ScreenSize
  type
    TScreenSize_Struct = packed record
      width: cuint16;
      // #comment (node index 1) - skipped
      height: cuint16;
      mwidth: cuint16;
      // #comment (node index 4) - skipped
      mheight: cuint16;
    end;

  // struct RefreshRates
  type
    TRefreshRates_Struct = packed record
      nRates: cuint16;
      list_1: Pointer; // list field
    end;

  // struct ModeInfo
  type
    TModeInfo_Struct = packed record
      id: cuint32;
      width: cuint16;
      height: cuint16;
      dot_clock: cuint32;
      hsync_start: cuint16;
      hsync_end: cuint16;
      htotal: cuint16;
      hskew: cuint16;
      vsync_start: cuint16;
      vsync_end: cuint16;
      vtotal: cuint16;
      name_len: cuint16;
      mode_flags: cuint32;
      // #comment (node index 13) - skipped
    end;

  // struct CrtcChange
  type
    TCrtcChange_Struct = packed record
      timestamp: cuint32;
      window: TWINDOW;
      crtc: TCRTC;
      mode: TMODE;
      rotation: cuint16;
      pad_5: array[0..2-1] of cuint8; // padding
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
    end;

  // struct OutputChange
  type
    TOutputChange_Struct = packed record
      timestamp: cuint32;
      config_timestamp: cuint32;
      window: TWINDOW;
      output: TOUTPUT;
      crtc: TCRTC;
      mode: TMODE;
      rotation: cuint16;
      connection: cuint8;
      subpixel_order: cuint8;
    end;

  // struct OutputProperty
  type
    TOutputProperty_Struct = packed record
      window: TWINDOW;
      output: TOUTPUT;
      atom: cuint32;
      timestamp: cuint32;
      status: cuint8;
      pad_5: array[0..11-1] of cuint8; // padding
    end;

  // struct ProviderChange
  type
    TProviderChange_Struct = packed record
      timestamp: cuint32;
      window: TWINDOW;
      provider: TPROVIDER;
      pad_3: array[0..16-1] of cuint8; // padding
    end;

  // struct ProviderProperty
  type
    TProviderProperty_Struct = packed record
      window: TWINDOW;
      provider: TPROVIDER;
      atom: cuint32;
      timestamp: cuint32;
      state: cuint8;
      pad_5: array[0..11-1] of cuint8; // padding
    end;

  // struct ResourceChange
  type
    TResourceChange_Struct = packed record
      timestamp: cuint32;
      window: TWINDOW;
      pad_2: array[0..20-1] of cuint8; // padding
    end;

  // struct MonitorInfo
  type
    TMonitorInfo_Struct = packed record
      name: cuint32;
      primary: cuint8;
      automatic: cuint8;
      nOutput: cuint16;
      x: cint16;
      y: cint16;
      width: cuint16;
      // #comment (node index 7) - skipped
      height: cuint16;
      // #comment (node index 9) - skipped
      width_in_millimeters: cuint32;
      height_in_millimeters: cuint32;
      list_12: Pointer; // list field
    end;

  // struct LeaseNotify
  type
    TLeaseNotify_Struct = packed record
      timestamp: cuint32;
      window: TWINDOW;
      lease: TLEASE;
      created: cuint8;
      pad_4: array[0..15-1] of cuint8; // padding
    end;

  // union NotifyData
  type
    TNotifyData_Union = packed record
      case Integer of
        0: (cc: cuint32);
        1: (oc: cuint32);
        2: (op: cuint32);
        3: (pc: cuint32);
        4: (pp: cuint32);
        5: (rc: cuint32);
        6: (lc: cuint32);
    end;

  // event ScreenChangeNotify
  type
    TScreenChangeNotify_Event = packed record
      rotation: cuint8;
      timestamp: cuint32;
      config_timestamp: cuint32;
      root: TWINDOW;
      request_window: TWINDOW;
      sizeID: cuint16;
      subpixel_order: cuint16;
      width: cuint16;
      height: cuint16;
      mwidth: cuint16;
      mheight: cuint16;
    end;

  // event Notify
  type
    TNotify_Event = packed record
      subCode: cuint8;
      u: cuint32;
    end;

  // error BadOutput
  type
    TBadOutput_Error = packed record
    end;

  // error BadCrtc
  type
    TBadCrtc_Error = packed record
    end;

  // error BadMode
  type
    TBadMode_Error = packed record
    end;

  // error BadProvider
  type
    TBadProvider_Error = packed record
    end;

  // request QueryVersion
  const XCB_QUERYVERSION = 0; // opcode
  type
    TQueryVersionReply = packed record
      major_version: cuint32;
      minor_version: cuint32;
    end;

  // request SetScreenConfig
  const XCB_SETSCREENCONFIG = 2; // opcode
  type
    TSetScreenConfigReply = packed record
      status: cuint8;
      new_timestamp: cuint32;
      config_timestamp: cuint32;
      root: TWINDOW;
      subpixel_order: cuint16;
    end;

  // request SelectInput
  const XCB_SELECTINPUT = 4; // opcode
  // request GetScreenInfo
  const XCB_GETSCREENINFO = 5; // opcode
  type
    TGetScreenInfoReply = packed record
      rotations: cuint8;
      root: TWINDOW;
      timestamp: cuint32;
      config_timestamp: cuint32;
      nSizes: cuint16;
      sizeID: cuint16;
      rotation: cuint16;
      rate: cuint16;
      nInfo: cuint16;
    end;

  // request GetScreenSizeRange
  const XCB_GETSCREENSIZERANGE = 6; // opcode
  type
    TGetScreenSizeRangeReply = packed record
      min_width: cuint16;
      min_height: cuint16;
      max_width: cuint16;
      max_height: cuint16;
    end;

  // request SetScreenSize
  const XCB_SETSCREENSIZE = 7; // opcode
  // request GetScreenResources
  const XCB_GETSCREENRESOURCES = 8; // opcode
  type
    TGetScreenResourcesReply = packed record
      timestamp: cuint32;
      config_timestamp: cuint32;
      num_crtcs: cuint16;
      num_outputs: cuint16;
      num_modes: cuint16;
      names_len: cuint16;
    end;

  // request GetOutputInfo
  const XCB_GETOUTPUTINFO = 9; // opcode
  type
    TGetOutputInfoReply = packed record
      status: cuint8;
      timestamp: cuint32;
      crtc: TCRTC;
      mm_width: cuint32;
      mm_height: cuint32;
      connection: cuint8;
      subpixel_order: cuint8;
      num_crtcs: cuint16;
      num_modes: cuint16;
      num_preferred: cuint16;
      num_clones: cuint16;
      name_len: cuint16;
    end;

  // request ListOutputProperties
  const XCB_LISTOUTPUTPROPERTIES = 10; // opcode
  type
    TListOutputPropertiesReply = packed record
      num_atoms: cuint16;
    end;

  // request QueryOutputProperty
  const XCB_QUERYOUTPUTPROPERTY = 11; // opcode
  type
    TQueryOutputPropertyReply = packed record
      pending: cuint8;
      range: cuint8;
      immutable: cuint8;
    end;

  // request ConfigureOutputProperty
  const XCB_CONFIGUREOUTPUTPROPERTY = 12; // opcode
  // request ChangeOutputProperty
  const XCB_CHANGEOUTPUTPROPERTY = 13; // opcode
  // request DeleteOutputProperty
  const XCB_DELETEOUTPUTPROPERTY = 14; // opcode
  // request GetOutputProperty
  const XCB_GETOUTPUTPROPERTY = 15; // opcode
  type
    TGetOutputPropertyReply = packed record
      format: cuint8;
      _type: cuint32;
      bytes_after: cuint32;
      num_items: cuint32;
    end;

  // request CreateMode
  const XCB_CREATEMODE = 16; // opcode
  type
    TCreateModeReply = packed record
      mode: TMODE;
    end;

  // request DestroyMode
  const XCB_DESTROYMODE = 17; // opcode
  // request AddOutputMode
  const XCB_ADDOUTPUTMODE = 18; // opcode
  // request DeleteOutputMode
  const XCB_DELETEOUTPUTMODE = 19; // opcode
  // request GetCrtcInfo
  const XCB_GETCRTCINFO = 20; // opcode
  type
    TGetCrtcInfoReply = packed record
      status: cuint8;
      timestamp: cuint32;
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
      mode: TMODE;
      rotation: cuint16;
      rotations: cuint16;
      num_outputs: cuint16;
      num_possible_outputs: cuint16;
    end;

  // request SetCrtcConfig
  const XCB_SETCRTCCONFIG = 21; // opcode
  type
    TSetCrtcConfigReply = packed record
      status: cuint8;
      timestamp: cuint32;
    end;

  // request GetCrtcGammaSize
  const XCB_GETCRTCGAMMASIZE = 22; // opcode
  type
    TGetCrtcGammaSizeReply = packed record
      size: cuint16;
    end;

  // request GetCrtcGamma
  const XCB_GETCRTCGAMMA = 23; // opcode
  type
    TGetCrtcGammaReply = packed record
      size: cuint16;
    end;

  // request SetCrtcGamma
  const XCB_SETCRTCGAMMA = 24; // opcode
  // request GetScreenResourcesCurrent
  const XCB_GETSCREENRESOURCESCURRENT = 25; // opcode
  type
    TGetScreenResourcesCurrentReply = packed record
      timestamp: cuint32;
      config_timestamp: cuint32;
      num_crtcs: cuint16;
      num_outputs: cuint16;
      num_modes: cuint16;
      names_len: cuint16;
    end;

  // request SetCrtcTransform
  const XCB_SETCRTCTRANSFORM = 26; // opcode
  // request GetCrtcTransform
  const XCB_GETCRTCTRANSFORM = 27; // opcode
  type
    TGetCrtcTransformReply = packed record
      pending_transform: cuint32;
      has_transforms: cuint8;
      current_transform: cuint32;
      pending_len: cuint16;
      pending_nparams: cuint16;
      current_len: cuint16;
      current_nparams: cuint16;
    end;

  // request GetPanning
  const XCB_GETPANNING = 28; // opcode
  type
    TGetPanningReply = packed record
      status: cuint8;
      timestamp: cuint32;
      left: cuint16;
      top: cuint16;
      width: cuint16;
      height: cuint16;
      track_left: cuint16;
      track_top: cuint16;
      track_width: cuint16;
      track_height: cuint16;
      border_left: cint16;
      border_top: cint16;
      border_right: cint16;
      border_bottom: cint16;
    end;

  // request SetPanning
  const XCB_SETPANNING = 29; // opcode
  type
    TSetPanningReply = packed record
      status: cuint8;
      timestamp: cuint32;
    end;

  // request SetOutputPrimary
  const XCB_SETOUTPUTPRIMARY = 30; // opcode
  // request GetOutputPrimary
  const XCB_GETOUTPUTPRIMARY = 31; // opcode
  type
    TGetOutputPrimaryReply = packed record
      output: TOUTPUT;
    end;

  // request GetProviders
  const XCB_GETPROVIDERS = 32; // opcode
  type
    TGetProvidersReply = packed record
      timestamp: cuint32;
      num_providers: cuint16;
    end;

  // request GetProviderInfo
  const XCB_GETPROVIDERINFO = 33; // opcode
  type
    TGetProviderInfoReply = packed record
      status: cuint8;
      timestamp: cuint32;
      capabilities: cuint32;
      num_crtcs: cuint16;
      num_outputs: cuint16;
      num_associated_providers: cuint16;
      name_len: cuint16;
    end;

  // request SetProviderOffloadSink
  const XCB_SETPROVIDEROFFLOADSINK = 34; // opcode
  // request SetProviderOutputSource
  const XCB_SETPROVIDEROUTPUTSOURCE = 35; // opcode
  // request ListProviderProperties
  const XCB_LISTPROVIDERPROPERTIES = 36; // opcode
  type
    TListProviderPropertiesReply = packed record
      num_atoms: cuint16;
    end;

  // request QueryProviderProperty
  const XCB_QUERYPROVIDERPROPERTY = 37; // opcode
  type
    TQueryProviderPropertyReply = packed record
      pending: cuint8;
      range: cuint8;
      immutable: cuint8;
    end;

  // request ConfigureProviderProperty
  const XCB_CONFIGUREPROVIDERPROPERTY = 38; // opcode
  // request ChangeProviderProperty
  const XCB_CHANGEPROVIDERPROPERTY = 39; // opcode
  // request DeleteProviderProperty
  const XCB_DELETEPROVIDERPROPERTY = 40; // opcode
  // request GetProviderProperty
  const XCB_GETPROVIDERPROPERTY = 41; // opcode
  type
    TGetProviderPropertyReply = packed record
      format: cuint8;
      _type: cuint32;
      bytes_after: cuint32;
      num_items: cuint32;
    end;

  // request GetMonitors
  const XCB_GETMONITORS = 42; // opcode
  type
    TGetMonitorsReply = packed record
      timestamp: cuint32;
      nMonitors: cuint32;
      nOutputs: cuint32;
    end;

  // request SetMonitor
  const XCB_SETMONITOR = 43; // opcode
  // request DeleteMonitor
  const XCB_DELETEMONITOR = 44; // opcode
  // request CreateLease
  const XCB_CREATELEASE = 45; // opcode
  type
    TCreateLeaseReply = packed record
      nfd: cuint8;
    end;

  // request FreeLease
  const XCB_FREELEASE = 46; // opcode

implementation

end.
