unit render;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from render.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // xidtype GLYPHSET
  type TGLYPHSET = cuint32;

  // xidtype PICTURE
  type TPICTURE = cuint32;

  // xidtype PICTFORMAT
  type TPICTFORMAT = cuint32;

  // typedef GLYPH -> CARD32
  type TGLYPH = cuint32;

  // typedef FIXED -> INT32
  type TFIXED = cint32;

  // enum PictType
  const PictType_Indexed = 0;
  const PictType_Direct = 1;

  // enum Picture
  const Picture_None = 0;

  // enum PictOp
  const PictOp_Clear = 0;
  const PictOp_Src = 1;
  const PictOp_Dst = 2;
  const PictOp_Over = 3;
  const PictOp_OverReverse = 4;
  const PictOp_In = 5;
  const PictOp_InReverse = 6;
  const PictOp_Out = 7;
  const PictOp_OutReverse = 8;
  const PictOp_Atop = 9;
  const PictOp_AtopReverse = 10;
  const PictOp_Xor = 11;
  const PictOp_Add = 12;
  const PictOp_Saturate = 13;
  const PictOp_DisjointClear = 16;
  const PictOp_DisjointSrc = 17;
  const PictOp_DisjointDst = 18;
  const PictOp_DisjointOver = 19;
  const PictOp_DisjointOverReverse = 20;
  const PictOp_DisjointIn = 21;
  const PictOp_DisjointInReverse = 22;
  const PictOp_DisjointOut = 23;
  const PictOp_DisjointOutReverse = 24;
  const PictOp_DisjointAtop = 25;
  const PictOp_DisjointAtopReverse = 26;
  const PictOp_DisjointXor = 27;
  const PictOp_ConjointClear = 32;
  const PictOp_ConjointSrc = 33;
  const PictOp_ConjointDst = 34;
  const PictOp_ConjointOver = 35;
  const PictOp_ConjointOverReverse = 36;
  const PictOp_ConjointIn = 37;
  const PictOp_ConjointInReverse = 38;
  const PictOp_ConjointOut = 39;
  const PictOp_ConjointOutReverse = 40;
  const PictOp_ConjointAtop = 41;
  const PictOp_ConjointAtopReverse = 42;
  const PictOp_ConjointXor = 43;
  const PictOp_Multiply = 48;
  const PictOp_Screen = 49;
  const PictOp_Overlay = 50;
  const PictOp_Darken = 51;
  const PictOp_Lighten = 52;
  const PictOp_ColorDodge = 53;
  const PictOp_ColorBurn = 54;
  const PictOp_HardLight = 55;
  const PictOp_SoftLight = 56;
  const PictOp_Difference = 57;
  const PictOp_Exclusion = 58;
  const PictOp_HSLHue = 59;
  const PictOp_HSLSaturation = 60;
  const PictOp_HSLColor = 61;
  const PictOp_HSLLuminosity = 62;

  // enum PolyEdge
  const PolyEdge_Sharp = 0;
  const PolyEdge_Smooth = 1;

  // enum PolyMode
  const PolyMode_Precise = 0;
  const PolyMode_Imprecise = 1;

  // enum CP
  const CP_Repeat = 1;
  const CP_AlphaMap = 2;
  const CP_AlphaXOrigin = 4;
  const CP_AlphaYOrigin = 8;
  const CP_ClipXOrigin = 16;
  const CP_ClipYOrigin = 32;
  const CP_ClipMask = 64;
  const CP_GraphicsExposure = 128;
  const CP_SubwindowMode = 256;
  const CP_PolyEdge = 512;
  const CP_PolyMode = 1024;
  const CP_Dither = 2048;
  const CP_ComponentAlpha = 4096;

  // enum SubPixel
  const SubPixel_Unknown = 0;
  const SubPixel_HorizontalRGB = 1;
  const SubPixel_HorizontalBGR = 2;
  const SubPixel_VerticalRGB = 3;
  const SubPixel_VerticalBGR = 4;
  const SubPixel_None = 5;

  // enum Repeat
  const Repeat_None = 0;
  const Repeat_Normal = 1;
  const Repeat_Pad = 2;
  const Repeat_Reflect = 3;

  // struct DIRECTFORMAT
  type
    TDIRECTFORMAT_Struct = packed record
      red_shift: cuint16;
      red_mask: cuint16;
      green_shift: cuint16;
      green_mask: cuint16;
      blue_shift: cuint16;
      blue_mask: cuint16;
      alpha_shift: cuint16;
      alpha_mask: cuint16;
    end;

  // struct PICTFORMINFO
  type
    TPICTFORMINFO_Struct = packed record
      id: TPICTFORMAT;
      _type: cuint8;
      depth: cuint8;
      pad_3: array[0..2-1] of cuint8; // padding
      direct: cuint32;
      colormap: cuint32;
    end;

  // struct PICTVISUAL
  type
    TPICTVISUAL_Struct = packed record
      visual: cuint32;
      format: TPICTFORMAT;
    end;

  // struct PICTDEPTH
  type
    TPICTDEPTH_Struct = packed record
      depth: cuint8;
      pad_1: array[0..1-1] of cuint8; // padding
      num_visuals: cuint16;
      pad_3: array[0..4-1] of cuint8; // padding
      list_4: Pointer; // list field
    end;

  // struct PICTSCREEN
  type
    TPICTSCREEN_Struct = packed record
      num_depths: cuint32;
      fallback: TPICTFORMAT;
      list_2: Pointer; // list field
    end;

  // struct INDEXVALUE
  type
    TINDEXVALUE_Struct = packed record
      pixel: cuint32;
      red: cuint16;
      green: cuint16;
      blue: cuint16;
      alpha: cuint16;
    end;

  // struct COLOR
  type
    TCOLOR_Struct = packed record
      red: cuint16;
      green: cuint16;
      blue: cuint16;
      alpha: cuint16;
    end;

  // struct POINTFIX
  type
    TPOINTFIX_Struct = packed record
      x: TFIXED;
      y: TFIXED;
    end;

  // struct LINEFIX
  type
    TLINEFIX_Struct = packed record
      p1: cuint32;
      p2: cuint32;
    end;

  // struct TRIANGLE
  type
    TTRIANGLE_Struct = packed record
      p1: cuint32;
      p2: cuint32;
      p3: cuint32;
    end;

  // struct TRAPEZOID
  type
    TTRAPEZOID_Struct = packed record
      top: TFIXED;
      bottom: TFIXED;
      left: cuint32;
      right: cuint32;
    end;

  // struct GLYPHINFO
  type
    TGLYPHINFO_Struct = packed record
      width: cuint16;
      height: cuint16;
      x: cint16;
      y: cint16;
      x_off: cint16;
      y_off: cint16;
    end;

  // struct TRANSFORM
  type
    TTRANSFORM_Struct = packed record
      matrix11: TFIXED;
      matrix12: TFIXED;
      matrix13: TFIXED;
      matrix21: TFIXED;
      matrix22: TFIXED;
      matrix23: TFIXED;
      matrix31: TFIXED;
      matrix32: TFIXED;
      matrix33: TFIXED;
    end;

  // struct ANIMCURSORELT
  type
    TANIMCURSORELT_Struct = packed record
      cursor: cuint32;
      delay: cuint32;
    end;

  // struct SPANFIX
  type
    TSPANFIX_Struct = packed record
      l: TFIXED;
      r: TFIXED;
      y: TFIXED;
    end;

  // struct TRAP
  type
    TTRAP_Struct = packed record
      top: cuint32;
      bot: cuint32;
    end;

  // error PictFormat
  type
    TPictFormat_Error = packed record
    end;

  // error Picture
  type
    TPicture_Error = packed record
    end;

  // error PictOp
  type
    TPictOp_Error = packed record
    end;

  // error GlyphSet
  type
    TGlyphSet_Error = packed record
    end;

  // error Glyph
  type
    TGlyph_Error = packed record
    end;

  // request QueryVersion
  const XCB_QUERYVERSION = 0; // opcode
  type
    TQueryVersionReply = packed record
      major_version: cuint32;
      minor_version: cuint32;
    end;

  // request QueryPictFormats
  const XCB_QUERYPICTFORMATS = 1; // opcode
  type
    TQueryPictFormatsReply = packed record
      num_formats: cuint32;
      num_screens: cuint32;
      num_depths: cuint32;
      num_visuals: cuint32;
      num_subpixel: cuint32;
    end;

  // request QueryPictIndexValues
  const XCB_QUERYPICTINDEXVALUES = 2; // opcode
  type
    TQueryPictIndexValuesReply = packed record
      num_values: cuint32;
    end;

  // request CreatePicture
  const XCB_CREATEPICTURE = 4; // opcode
  // request ChangePicture
  const XCB_CHANGEPICTURE = 5; // opcode
  // request SetPictureClipRectangles
  const XCB_SETPICTURECLIPRECTANGLES = 6; // opcode
  // request FreePicture
  const XCB_FREEPICTURE = 7; // opcode
  // request Composite
  const XCB_COMPOSITE = 8; // opcode
  // request Trapezoids
  const XCB_TRAPEZOIDS = 10; // opcode
  // request Triangles
  const XCB_TRIANGLES = 11; // opcode
  // request TriStrip
  const XCB_TRISTRIP = 12; // opcode
  // request TriFan
  const XCB_TRIFAN = 13; // opcode
  // request CreateGlyphSet
  const XCB_CREATEGLYPHSET = 17; // opcode
  // request ReferenceGlyphSet
  const XCB_REFERENCEGLYPHSET = 18; // opcode
  // request FreeGlyphSet
  const XCB_FREEGLYPHSET = 19; // opcode
  // request AddGlyphs
  const XCB_ADDGLYPHS = 20; // opcode
  // request FreeGlyphs
  const XCB_FREEGLYPHS = 22; // opcode
  // request CompositeGlyphs8
  const XCB_COMPOSITEGLYPHS8 = 23; // opcode
  // request CompositeGlyphs16
  const XCB_COMPOSITEGLYPHS16 = 24; // opcode
  // request CompositeGlyphs32
  const XCB_COMPOSITEGLYPHS32 = 25; // opcode
  // request FillRectangles
  const XCB_FILLRECTANGLES = 26; // opcode
  // request CreateCursor
  const XCB_CREATECURSOR = 27; // opcode
  // request SetPictureTransform
  const XCB_SETPICTURETRANSFORM = 28; // opcode
  // request QueryFilters
  const XCB_QUERYFILTERS = 29; // opcode
  type
    TQueryFiltersReply = packed record
      num_aliases: cuint32;
      num_filters: cuint32;
    end;

  // request SetPictureFilter
  const XCB_SETPICTUREFILTER = 30; // opcode
  // request CreateAnimCursor
  const XCB_CREATEANIMCURSOR = 31; // opcode
  // request AddTraps
  const XCB_ADDTRAPS = 32; // opcode
  // request CreateSolidFill
  const XCB_CREATESOLIDFILL = 33; // opcode
  // request CreateLinearGradient
  const XCB_CREATELINEARGRADIENT = 34; // opcode
  // request CreateRadialGradient
  const XCB_CREATERADIALGRADIENT = 35; // opcode
  // request CreateConicalGradient
  const XCB_CREATECONICALGRADIENT = 36; // opcode

implementation

end.
