unit sync;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from sync.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // xidtype ALARM
  type TALARM = cuint32;

  // xidtype COUNTER
  type TCOUNTER = cuint32;

  // xidtype FENCE
  type TFENCE = cuint32;

  // enum ALARMSTATE
  const ALARMSTATE_Active = 0;
  const ALARMSTATE_Inactive = 1;
  const ALARMSTATE_Destroyed = 2;

  // enum TESTTYPE
  const TESTTYPE_PositiveTransition = 0;
  const TESTTYPE_NegativeTransition = 1;
  const TESTTYPE_PositiveComparison = 2;
  const TESTTYPE_NegativeComparison = 3;

  // enum VALUETYPE
  const VALUETYPE_Absolute = 0;
  const VALUETYPE_Relative = 1;

  // enum CA
  const CA_Counter = 1;
  const CA_ValueType = 2;
  const CA_Value = 4;
  const CA_TestType = 8;
  const CA_Delta = 16;
  const CA_Events = 32;

  // struct INT64
  type
    TINT64_Struct = packed record
      hi: cint32;
      lo: cuint32;
    end;

  // struct SYSTEMCOUNTER
  type
    TSYSTEMCOUNTER_Struct = packed record
      counter: TCOUNTER;
      resolution: cuint32;
      name_len: cuint16;
      list_3: Pointer; // list field
      pad_4: cuint8; // pad (unspecified bytes)
    end;

  // struct TRIGGER
  type
    TTRIGGER_Struct = packed record
      counter: TCOUNTER;
      wait_type: cuint32;
      wait_value: cuint32;
      test_type: cuint32;
    end;

  // struct WAITCONDITION
  type
    TWAITCONDITION_Struct = packed record
      trigger: cuint32;
      event_threshold: cuint32;
    end;

  // event CounterNotify
  type
    TCounterNotify_Event = packed record
      kind: cuint8;
      counter: TCOUNTER;
      wait_value: cuint32;
      counter_value: cuint32;
      timestamp: cuint32;
      count: cuint16;
      destroyed: cuint8;
    end;

  // event AlarmNotify
  type
    TAlarmNotify_Event = packed record
      kind: cuint8;
      alarm: TALARM;
      counter_value: cuint32;
      alarm_value: cuint32;
      timestamp: cuint32;
      state: cuint8;
    end;

  // error Counter
  type
    TCounter_Error = packed record
      bad_counter: cuint32;
      minor_opcode: cuint16;
      major_opcode: cuint8;
    end;

  // error Alarm
  type
    TAlarm_Error = packed record
      bad_alarm: cuint32;
      minor_opcode: cuint16;
      major_opcode: cuint8;
    end;

  // error Fence
  type
    TFence_Error = packed record
      bad_fence: cuint32;
      minor_opcode: cuint16;
      major_opcode: cuint8;
    end;

  // request Initialize
  const XCB_INITIALIZE = 0; // opcode
  type
    TInitializeReply = packed record
      major_version: cuint8;
      minor_version: cuint8;
    end;

  // request ListSystemCounters
  const XCB_LISTSYSTEMCOUNTERS = 1; // opcode
  type
    TListSystemCountersReply = packed record
      counters_len: cuint32;
    end;

  // request CreateCounter
  const XCB_CREATECOUNTER = 2; // opcode
  // request DestroyCounter
  const XCB_DESTROYCOUNTER = 6; // opcode
  // request QueryCounter
  const XCB_QUERYCOUNTER = 5; // opcode
  type
    TQueryCounterReply = packed record
      counter_value: cuint32;
    end;

  // request Await
  const XCB_AWAIT = 7; // opcode
  // request ChangeCounter
  const XCB_CHANGECOUNTER = 4; // opcode
  // request SetCounter
  const XCB_SETCOUNTER = 3; // opcode
  // request CreateAlarm
  const XCB_CREATEALARM = 8; // opcode
  // request ChangeAlarm
  const XCB_CHANGEALARM = 9; // opcode
  // request DestroyAlarm
  const XCB_DESTROYALARM = 11; // opcode
  // request QueryAlarm
  const XCB_QUERYALARM = 10; // opcode
  type
    TQueryAlarmReply = packed record
      trigger: cuint32;
      delta: cuint32;
      events: cuint8;
      state: cuint8;
    end;

  // request SetPriority
  const XCB_SETPRIORITY = 12; // opcode
  // request GetPriority
  const XCB_GETPRIORITY = 13; // opcode
  type
    TGetPriorityReply = packed record
      priority: cint32;
    end;

  // request CreateFence
  const XCB_CREATEFENCE = 14; // opcode
  // request TriggerFence
  const XCB_TRIGGERFENCE = 15; // opcode
  // request ResetFence
  const XCB_RESETFENCE = 16; // opcode
  // request DestroyFence
  const XCB_DESTROYFENCE = 17; // opcode
  // request QueryFence
  const XCB_QUERYFENCE = 18; // opcode
  type
    TQueryFenceReply = packed record
      triggered: cuint8;
    end;

  // request AwaitFence
  const XCB_AWAITFENCE = 19; // opcode

implementation

end.
