unit xf86vidmode;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from xf86vidmode.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // typedef SYNCRANGE -> CARD32
  type TSYNCRANGE = cuint32;

  // typedef DOTCLOCK -> CARD32
  type TDOTCLOCK = cuint32;

  // enum ModeFlag
  const ModeFlag_Positive_HSync = 1;
  const ModeFlag_Negative_HSync = 2;
  const ModeFlag_Positive_VSync = 4;
  const ModeFlag_Negative_VSync = 8;
  const ModeFlag_Interlace = 16;
  const ModeFlag_Composite_Sync = 32;
  const ModeFlag_Positive_CSync = 64;
  const ModeFlag_Negative_CSync = 128;
  const ModeFlag_HSkew = 256;
  const ModeFlag_Broadcast = 512;
  const ModeFlag_Pixmux = 1024;
  const ModeFlag_Double_Clock = 2048;
  const ModeFlag_Half_Clock = 4096;

  // enum ClockFlag
  const ClockFlag_Programable = 1;

  // enum Permission
  const Permission_Read = 1;
  const Permission_Write = 2;

  // struct ModeInfo
  type
    TModeInfo_Struct = packed record
      dotclock: TDOTCLOCK;
      hdisplay: cuint16;
      hsyncstart: cuint16;
      hsyncend: cuint16;
      htotal: cuint16;
      hskew: cuint32;
      vdisplay: cuint16;
      vsyncstart: cuint16;
      vsyncend: cuint16;
      vtotal: cuint16;
      pad_10: array[0..4-1] of cuint8; // padding
      flags: cuint32;
      pad_12: array[0..12-1] of cuint8; // padding
      privsize: cuint32;
    end;

  // error BadClock
  type
    TBadClock_Error = packed record
    end;

  // error BadHTimings
  type
    TBadHTimings_Error = packed record
    end;

  // error BadVTimings
  type
    TBadVTimings_Error = packed record
    end;

  // error ModeUnsuitable
  type
    TModeUnsuitable_Error = packed record
    end;

  // error ExtensionDisabled
  type
    TExtensionDisabled_Error = packed record
    end;

  // error ClientNotLocal
  type
    TClientNotLocal_Error = packed record
    end;

  // error ZoomLocked
  type
    TZoomLocked_Error = packed record
    end;

  // request QueryVersion
  const XCB_QUERYVERSION = 0; // opcode
  type
    TQueryVersionReply = packed record
      major_version: cuint16;
      minor_version: cuint16;
    end;

  // request GetModeLine
  const XCB_GETMODELINE = 1; // opcode
  type
    TGetModeLineReply = packed record
      dotclock: TDOTCLOCK;
      hdisplay: cuint16;
      hsyncstart: cuint16;
      hsyncend: cuint16;
      htotal: cuint16;
      hskew: cuint16;
      vdisplay: cuint16;
      vsyncstart: cuint16;
      vsyncend: cuint16;
      vtotal: cuint16;
      flags: cuint32;
      privsize: cuint32;
    end;

  // request ModModeLine
  const XCB_MODMODELINE = 2; // opcode
  // request SwitchMode
  const XCB_SWITCHMODE = 3; // opcode
  // request GetMonitor
  const XCB_GETMONITOR = 4; // opcode
  type
    TGetMonitorReply = packed record
      vendor_length: cuint8;
      model_length: cuint8;
      num_hsync: cuint8;
      num_vsync: cuint8;
    end;

  // request LockModeSwitch
  const XCB_LOCKMODESWITCH = 5; // opcode
  // request GetAllModeLines
  const XCB_GETALLMODELINES = 6; // opcode
  type
    TGetAllModeLinesReply = packed record
      modecount: cuint32;
    end;

  // request AddModeLine
  const XCB_ADDMODELINE = 7; // opcode
  // request DeleteModeLine
  const XCB_DELETEMODELINE = 8; // opcode
  // request ValidateModeLine
  const XCB_VALIDATEMODELINE = 9; // opcode
  type
    TValidateModeLineReply = packed record
      status: cuint32;
    end;

  // request SwitchToMode
  const XCB_SWITCHTOMODE = 10; // opcode
  // request GetViewPort
  const XCB_GETVIEWPORT = 11; // opcode
  type
    TGetViewPortReply = packed record
      x: cuint32;
      y: cuint32;
    end;

  // request SetViewPort
  const XCB_SETVIEWPORT = 12; // opcode
  // request GetDotClocks
  const XCB_GETDOTCLOCKS = 13; // opcode
  type
    TGetDotClocksReply = packed record
      flags: cuint32;
      clocks: cuint32;
      maxclocks: cuint32;
    end;

  // request SetClientVersion
  const XCB_SETCLIENTVERSION = 14; // opcode
  // request SetGamma
  const XCB_SETGAMMA = 15; // opcode
  // request GetGamma
  const XCB_GETGAMMA = 16; // opcode
  type
    TGetGammaReply = packed record
      red: cuint32;
      green: cuint32;
      blue: cuint32;
    end;

  // request GetGammaRamp
  const XCB_GETGAMMARAMP = 17; // opcode
  type
    TGetGammaRampReply = packed record
      size: cuint16;
    end;

  // request SetGammaRamp
  const XCB_SETGAMMARAMP = 18; // opcode
  // request GetGammaRampSize
  const XCB_GETGAMMARAMPSIZE = 19; // opcode
  type
    TGetGammaRampSizeReply = packed record
      size: cuint16;
    end;

  // request GetPermissions
  const XCB_GETPERMISSIONS = 20; // opcode
  type
    TGetPermissionsReply = packed record
      permissions: cuint32;
    end;


implementation

end.
