unit xinput;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from xinput.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // typedef EventClass -> CARD32
  type TEventClass = cuint32;

  // typedef KeyCode -> CARD8
  type TKeyCode = cuint8;

  // typedef DeviceId -> CARD16
  type TDeviceId = cuint16;

  // typedef FP1616 -> INT32
  type TFP1616 = cint32;

  // typedef EventTypeBase -> CARD8
  type TEventTypeBase = cuint8;

  // enum DeviceUse
  const DeviceUse_IsXPointer = 0;
  const DeviceUse_IsXKeyboard = 1;
  const DeviceUse_IsXExtensionDevice = 2;
  const DeviceUse_IsXExtensionKeyboard = 3;
  const DeviceUse_IsXExtensionPointer = 4;

  // enum InputClass
  const InputClass_Key = 0;
  const InputClass_Button = 1;
  const InputClass_Valuator = 2;
  const InputClass_Feedback = 3;
  const InputClass_Proximity = 4;
  const InputClass_Focus = 5;
  const InputClass_Other = 6;

  // enum ValuatorMode
  const ValuatorMode_Relative = 0;
  const ValuatorMode_Absolute = 1;

  // enum PropagateMode
  const PropagateMode_AddToList = 0;
  const PropagateMode_DeleteFromList = 1;

  // enum ModifierDevice
  const ModifierDevice_UseXKeyboard = 255;

  // enum DeviceInputMode
  const DeviceInputMode_AsyncThisDevice = 0;
  const DeviceInputMode_SyncThisDevice = 1;
  const DeviceInputMode_ReplayThisDevice = 2;
  const DeviceInputMode_AsyncOtherDevices = 3;
  const DeviceInputMode_AsyncAll = 4;
  const DeviceInputMode_SyncAll = 5;

  // enum FeedbackClass
  const FeedbackClass_Keyboard = 0;
  const FeedbackClass_Pointer = 1;
  const FeedbackClass_String = 2;
  const FeedbackClass_Integer = 3;
  const FeedbackClass_Led = 4;
  const FeedbackClass_Bell = 5;

  // enum ChangeFeedbackControlMask
  const ChangeFeedbackControlMask_KeyClickPercent = 1;
  const ChangeFeedbackControlMask_Percent = 2;
  const ChangeFeedbackControlMask_Pitch = 4;
  const ChangeFeedbackControlMask_Duration = 8;
  const ChangeFeedbackControlMask_Led = 16;
  const ChangeFeedbackControlMask_LedMode = 32;
  const ChangeFeedbackControlMask_Key = 64;
  const ChangeFeedbackControlMask_AutoRepeatMode = 128;
  const ChangeFeedbackControlMask_String = 1;
  const ChangeFeedbackControlMask_Integer = 1;
  const ChangeFeedbackControlMask_AccelNum = 1;
  const ChangeFeedbackControlMask_AccelDenom = 2;
  const ChangeFeedbackControlMask_Threshold = 4;

  // enum ValuatorStateModeMask
  const ValuatorStateModeMask_DeviceModeAbsolute = 1;
  const ValuatorStateModeMask_OutOfProximity = 2;

  // enum DeviceControl
  const DeviceControl_resolution = 1;
  const DeviceControl_abs_calib = 2;
  const DeviceControl_core = 3;
  const DeviceControl_enable = 4;
  const DeviceControl_abs_area = 5;

  // enum PropertyFormat
  const PropertyFormat_8Bits = 8;
  const PropertyFormat_16Bits = 16;
  const PropertyFormat_32Bits = 32;

  // enum Device
  const Device_All = 0;
  const Device_AllMaster = 1;

  // enum HierarchyChangeType
  const HierarchyChangeType_AddMaster = 1;
  const HierarchyChangeType_RemoveMaster = 2;
  const HierarchyChangeType_AttachSlave = 3;
  const HierarchyChangeType_DetachSlave = 4;

  // enum ChangeMode
  const ChangeMode_Attach = 1;
  const ChangeMode_Float = 2;

  // enum XIEventMask
  const XIEventMask_DeviceChanged = 2;
  const XIEventMask_KeyPress = 4;
  const XIEventMask_KeyRelease = 8;
  const XIEventMask_ButtonPress = 16;
  const XIEventMask_ButtonRelease = 32;
  const XIEventMask_Motion = 64;
  const XIEventMask_Enter = 128;
  const XIEventMask_Leave = 256;
  const XIEventMask_FocusIn = 512;
  const XIEventMask_FocusOut = 1024;
  const XIEventMask_Hierarchy = 2048;
  const XIEventMask_Property = 4096;
  const XIEventMask_RawKeyPress = 8192;
  const XIEventMask_RawKeyRelease = 16384;
  const XIEventMask_RawButtonPress = 32768;
  const XIEventMask_RawButtonRelease = 65536;
  const XIEventMask_RawMotion = 131072;
  const XIEventMask_TouchBegin = 262144;
  const XIEventMask_TouchUpdate = 524288;
  const XIEventMask_TouchEnd = 1048576;
  const XIEventMask_TouchOwnership = 2097152;
  const XIEventMask_RawTouchBegin = 4194304;
  const XIEventMask_RawTouchUpdate = 8388608;
  const XIEventMask_RawTouchEnd = 16777216;
  const XIEventMask_BarrierHit = 33554432;
  const XIEventMask_BarrierLeave = 67108864;

  // enum DeviceClassType
  const DeviceClassType_Key = 0;
  const DeviceClassType_Button = 1;
  const DeviceClassType_Valuator = 2;
  const DeviceClassType_Scroll = 3;
  const DeviceClassType_Touch = 8;
  const DeviceClassType_Gesture = 9;

  // enum DeviceType
  const DeviceType_MasterPointer = 1;
  const DeviceType_MasterKeyboard = 2;
  const DeviceType_SlavePointer = 3;
  const DeviceType_SlaveKeyboard = 4;
  const DeviceType_FloatingSlave = 5;

  // enum ScrollFlags
  const ScrollFlags_NoEmulation = 1;
  const ScrollFlags_Preferred = 2;

  // enum ScrollType
  const ScrollType_Vertical = 1;
  const ScrollType_Horizontal = 2;

  // enum TouchMode
  const TouchMode_Direct = 1;
  const TouchMode_Dependent = 2;

  // enum GrabOwner
  const GrabOwner_NoOwner = 0;
  const GrabOwner_Owner = 1;

  // enum EventMode
  const EventMode_AsyncDevice = 0;
  const EventMode_SyncDevice = 1;
  const EventMode_ReplayDevice = 2;
  const EventMode_AsyncPairedDevice = 3;
  const EventMode_AsyncPair = 4;
  const EventMode_SyncPair = 5;
  const EventMode_AcceptTouch = 6;
  const EventMode_RejectTouch = 7;

  // enum GrabMode22
  const GrabMode22_Sync = 0;
  const GrabMode22_Async = 1;
  const GrabMode22_Touch = 2;

  // enum GrabType
  const GrabType_Button = 0;
  const GrabType_Keycode = 1;
  const GrabType_Enter = 2;
  const GrabType_FocusIn = 3;
  const GrabType_TouchBegin = 4;
  const GrabType_GesturePinchBegin = 5;
  const GrabType_GestureSwipeBegin = 6;

  // enum ModifierMask
  const ModifierMask_Any = -2147483648;

  // enum MoreEventsMask
  const MoreEventsMask_MoreEvents = 128;

  // enum ClassesReportedMask
  const ClassesReportedMask_OutOfProximity = 128;
  const ClassesReportedMask_DeviceModeAbsolute = 64;
  const ClassesReportedMask_ReportingValuators = 4;
  const ClassesReportedMask_ReportingButtons = 2;
  const ClassesReportedMask_ReportingKeys = 1;

  // enum ChangeDevice
  const ChangeDevice_NewPointer = 0;
  const ChangeDevice_NewKeyboard = 1;

  // enum DeviceChange
  const DeviceChange_Added = 0;
  const DeviceChange_Removed = 1;
  const DeviceChange_Enabled = 2;
  const DeviceChange_Disabled = 3;
  const DeviceChange_Unrecoverable = 4;
  const DeviceChange_ControlChanged = 5;

  // enum ChangeReason
  const ChangeReason_SlaveSwitch = 1;
  const ChangeReason_DeviceChange = 2;

  // enum KeyEventFlags
  const KeyEventFlags_KeyRepeat = 65536;

  // enum PointerEventFlags
  const PointerEventFlags_PointerEmulated = 65536;

  // enum NotifyMode
  const NotifyMode_Normal = 0;
  const NotifyMode_Grab = 1;
  const NotifyMode_Ungrab = 2;
  const NotifyMode_WhileGrabbed = 3;
  const NotifyMode_PassiveGrab = 4;
  const NotifyMode_PassiveUngrab = 5;

  // enum NotifyDetail
  const NotifyDetail_Ancestor = 0;
  const NotifyDetail_Virtual = 1;
  const NotifyDetail_Inferior = 2;
  const NotifyDetail_Nonlinear = 3;
  const NotifyDetail_NonlinearVirtual = 4;
  const NotifyDetail_Pointer = 5;
  const NotifyDetail_PointerRoot = 6;
  const NotifyDetail_None = 7;

  // enum HierarchyMask
  const HierarchyMask_MasterAdded = 1;
  const HierarchyMask_MasterRemoved = 2;
  const HierarchyMask_SlaveAdded = 4;
  const HierarchyMask_SlaveRemoved = 8;
  const HierarchyMask_SlaveAttached = 16;
  const HierarchyMask_SlaveDetached = 32;
  const HierarchyMask_DeviceEnabled = 64;
  const HierarchyMask_DeviceDisabled = 128;

  // enum PropertyFlag
  const PropertyFlag_Deleted = 0;
  const PropertyFlag_Created = 1;
  const PropertyFlag_Modified = 2;

  // enum TouchEventFlags
  const TouchEventFlags_TouchPendingEnd = 65536;
  const TouchEventFlags_TouchEmulatingPointer = 131072;

  // enum TouchOwnershipFlags
  const TouchOwnershipFlags_None = 0;

  // enum BarrierFlags
  const BarrierFlags_PointerReleased = 1;
  const BarrierFlags_DeviceIsGrabbed = 2;

  // enum GesturePinchEventFlags
  const GesturePinchEventFlags_GesturePinchCancelled = 1;

  // enum GestureSwipeEventFlags
  const GestureSwipeEventFlags_GestureSwipeCancelled = 1;

  // struct FP3232
  type
    TFP3232_Struct = packed record
      integral: cint32;
      frac: cuint32;
    end;

  // struct DeviceInfo
  type
    TDeviceInfo_Struct = packed record
      device_type: cuint32;
      device_id: cuint8;
      num_class_info: cuint8;
      device_use: cuint8;
      pad_4: array[0..1-1] of cuint8; // padding
    end;

  // struct KeyInfo
  type
    TKeyInfo_Struct = packed record
      class_id: cuint8;
      len: cuint8;
      min_keycode: TKeyCode;
      max_keycode: TKeyCode;
      num_keys: cuint16;
      pad_5: array[0..2-1] of cuint8; // padding
    end;

  // struct ButtonInfo
  type
    TButtonInfo_Struct = packed record
      class_id: cuint8;
      len: cuint8;
      num_buttons: cuint16;
    end;

  // struct AxisInfo
  type
    TAxisInfo_Struct = packed record
      resolution: cuint32;
      minimum: cint32;
      maximum: cint32;
    end;

  // struct ValuatorInfo
  type
    TValuatorInfo_Struct = packed record
      class_id: cuint8;
      len: cuint8;
      axes_len: cuint8;
      mode: cuint8;
      motion_size: cuint32;
      list_5: Pointer; // list field
    end;

  // struct InputInfo
  type
    TInputInfo_Struct = packed record
      class_id: cuint8;
      len: cuint8;
      switch_2: Pointer; // switch field - manual handling required
    end;

  // struct DeviceName
  type
    TDeviceName_Struct = packed record
      len: cuint8;
      list_1: Pointer; // list field
    end;

  // struct InputClassInfo
  type
    TInputClassInfo_Struct = packed record
      class_id: cuint8;
      event_type_base: TEventTypeBase;
    end;

  // struct DeviceTimeCoord
  type
    TDeviceTimeCoord_Struct = packed record
      time: cuint32;
      list_1: Pointer; // list field
    end;

  // struct KbdFeedbackState
  type
    TKbdFeedbackState_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      pitch: cuint16;
      duration: cuint16;
      led_mask: cuint32;
      led_values: cuint32;
      global_auto_repeat: cuint8;
      click: cuint8;
      percent: cuint8;
      pad_10: array[0..1-1] of cuint8; // padding
      list_11: Pointer; // list field
    end;

  // struct PtrFeedbackState
  type
    TPtrFeedbackState_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      pad_3: array[0..2-1] of cuint8; // padding
      accel_num: cuint16;
      accel_denom: cuint16;
      threshold: cuint16;
    end;

  // struct IntegerFeedbackState
  type
    TIntegerFeedbackState_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      resolution: cuint32;
      min_value: cint32;
      max_value: cint32;
    end;

  // struct StringFeedbackState
  type
    TStringFeedbackState_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      max_symbols: cuint16;
      num_keysyms: cuint16;
      list_5: Pointer; // list field
    end;

  // struct BellFeedbackState
  type
    TBellFeedbackState_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      percent: cuint8;
      pad_4: array[0..3-1] of cuint8; // padding
      pitch: cuint16;
      duration: cuint16;
    end;

  // struct LedFeedbackState
  type
    TLedFeedbackState_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      led_mask: cuint32;
      led_values: cuint32;
    end;

  // struct FeedbackState
  type
    TFeedbackState_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      switch_3: Pointer; // switch field - manual handling required
    end;

  // struct KbdFeedbackCtl
  type
    TKbdFeedbackCtl_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      key: TKeyCode;
      auto_repeat_mode: cuint8;
      key_click_percent: cint8;
      bell_percent: cint8;
      bell_pitch: cint16;
      bell_duration: cint16;
      led_mask: cuint32;
      led_values: cuint32;
    end;

  // struct PtrFeedbackCtl
  type
    TPtrFeedbackCtl_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      pad_3: array[0..2-1] of cuint8; // padding
      num: cint16;
      denom: cint16;
      threshold: cint16;
    end;

  // struct IntegerFeedbackCtl
  type
    TIntegerFeedbackCtl_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      int_to_display: cint32;
    end;

  // struct StringFeedbackCtl
  type
    TStringFeedbackCtl_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      pad_3: array[0..2-1] of cuint8; // padding
      num_keysyms: cuint16;
      list_5: Pointer; // list field
    end;

  // struct BellFeedbackCtl
  type
    TBellFeedbackCtl_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      percent: cint8;
      pad_4: array[0..3-1] of cuint8; // padding
      pitch: cint16;
      duration: cint16;
    end;

  // struct LedFeedbackCtl
  type
    TLedFeedbackCtl_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      led_mask: cuint32;
      led_values: cuint32;
    end;

  // struct FeedbackCtl
  type
    TFeedbackCtl_Struct = packed record
      class_id: cuint8;
      feedback_id: cuint8;
      len: cuint16;
      switch_3: Pointer; // switch field - manual handling required
    end;

  // struct KeyState
  type
    TKeyState_Struct = packed record
      class_id: cuint8;
      len: cuint8;
      num_keys: cuint8;
      pad_3: array[0..1-1] of cuint8; // padding
      list_4: Pointer; // list field
    end;

  // struct ButtonState
  type
    TButtonState_Struct = packed record
      class_id: cuint8;
      len: cuint8;
      num_buttons: cuint8;
      pad_3: array[0..1-1] of cuint8; // padding
      list_4: Pointer; // list field
    end;

  // struct ValuatorState
  type
    TValuatorState_Struct = packed record
      class_id: cuint8;
      len: cuint8;
      num_valuators: cuint8;
      mode: cuint8;
      list_4: Pointer; // list field
    end;

  // struct InputState
  type
    TInputState_Struct = packed record
      class_id: cuint8;
      len: cuint8;
      switch_2: Pointer; // switch field - manual handling required
    end;

  // struct DeviceResolutionState
  type
    TDeviceResolutionState_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      num_valuators: cuint32;
      list_3: Pointer; // list field
      list_4: Pointer; // list field
      list_5: Pointer; // list field
    end;

  // struct DeviceAbsCalibState
  type
    TDeviceAbsCalibState_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      min_x: cint32;
      max_x: cint32;
      min_y: cint32;
      max_y: cint32;
      flip_x: cuint32;
      flip_y: cuint32;
      rotation: cuint32;
      button_threshold: cuint32;
    end;

  // struct DeviceAbsAreaState
  type
    TDeviceAbsAreaState_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      offset_x: cuint32;
      offset_y: cuint32;
      width: cuint32;
      height: cuint32;
      screen: cuint32;
      following: cuint32;
    end;

  // struct DeviceCoreState
  type
    TDeviceCoreState_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      status: cuint8;
      iscore: cuint8;
      pad_4: array[0..2-1] of cuint8; // padding
    end;

  // struct DeviceEnableState
  type
    TDeviceEnableState_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      enable: cuint8;
      pad_3: array[0..3-1] of cuint8; // padding
    end;

  // struct DeviceState
  type
    TDeviceState_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      switch_2: Pointer; // switch field - manual handling required
    end;

  // struct DeviceResolutionCtl
  type
    TDeviceResolutionCtl_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      first_valuator: cuint8;
      num_valuators: cuint8;
      pad_4: array[0..2-1] of cuint8; // padding
      list_5: Pointer; // list field
    end;

  // struct DeviceAbsCalibCtl
  type
    TDeviceAbsCalibCtl_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      min_x: cint32;
      max_x: cint32;
      min_y: cint32;
      max_y: cint32;
      flip_x: cuint32;
      flip_y: cuint32;
      rotation: cuint32;
      button_threshold: cuint32;
    end;

  // struct DeviceAbsAreaCtrl
  type
    TDeviceAbsAreaCtrl_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      offset_x: cuint32;
      offset_y: cuint32;
      width: cint32;
      height: cint32;
      screen: cint32;
      following: cuint32;
    end;

  // struct DeviceCoreCtrl
  type
    TDeviceCoreCtrl_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      status: cuint8;
      pad_3: array[0..3-1] of cuint8; // padding
    end;

  // struct DeviceEnableCtrl
  type
    TDeviceEnableCtrl_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      enable: cuint8;
      pad_3: array[0..3-1] of cuint8; // padding
    end;

  // struct DeviceCtl
  type
    TDeviceCtl_Struct = packed record
      control_id: cuint16;
      len: cuint16;
      switch_2: Pointer; // switch field - manual handling required
    end;

  // struct GroupInfo
  type
    TGroupInfo_Struct = packed record
      base: cuint8;
      latched: cuint8;
      locked: cuint8;
      effective: cuint8;
    end;

  // struct ModifierInfo
  type
    TModifierInfo_Struct = packed record
      base: cuint32;
      latched: cuint32;
      locked: cuint32;
      effective: cuint32;
    end;

  // struct AddMaster
  type
    TAddMaster_Struct = packed record
      _type: cuint16;
      len: cuint16;
      name_len: cuint16;
      send_core: cuint8;
      enable: cuint8;
      list_5: Pointer; // list field
      pad_6: cuint8; // pad (unspecified bytes)
    end;

  // struct RemoveMaster
  type
    TRemoveMaster_Struct = packed record
      _type: cuint16;
      len: cuint16;
      deviceid: TDeviceId;
      return_mode: cuint8;
      pad_4: array[0..1-1] of cuint8; // padding
      return_pointer: TDeviceId;
      return_keyboard: TDeviceId;
    end;

  // struct AttachSlave
  type
    TAttachSlave_Struct = packed record
      _type: cuint16;
      len: cuint16;
      deviceid: TDeviceId;
      master: TDeviceId;
    end;

  // struct DetachSlave
  type
    TDetachSlave_Struct = packed record
      _type: cuint16;
      len: cuint16;
      deviceid: TDeviceId;
      pad_3: array[0..2-1] of cuint8; // padding
    end;

  // struct HierarchyChange
  type
    THierarchyChange_Struct = packed record
      _type: cuint16;
      len: cuint16;
      switch_2: Pointer; // switch field - manual handling required
    end;

  // struct EventMask
  type
    TEventMask_Struct = packed record
      deviceid: TDeviceId;
      mask_len: cuint16;
      list_2: Pointer; // list field
    end;

  // struct ButtonClass
  type
    TButtonClass_Struct = packed record
      _type: cuint16;
      len: cuint16;
      sourceid: TDeviceId;
      num_buttons: cuint16;
      list_4: Pointer; // list field
      list_5: Pointer; // list field
    end;

  // struct KeyClass
  type
    TKeyClass_Struct = packed record
      _type: cuint16;
      len: cuint16;
      sourceid: TDeviceId;
      num_keys: cuint16;
      list_4: Pointer; // list field
    end;

  // struct ScrollClass
  type
    TScrollClass_Struct = packed record
      _type: cuint16;
      len: cuint16;
      sourceid: TDeviceId;
      number: cuint16;
      scroll_type: cuint16;
      pad_5: array[0..2-1] of cuint8; // padding
      flags: cuint32;
      increment: cuint32;
    end;

  // struct TouchClass
  type
    TTouchClass_Struct = packed record
      _type: cuint16;
      len: cuint16;
      sourceid: TDeviceId;
      mode: cuint8;
      num_touches: cuint8;
    end;

  // struct GestureClass
  type
    TGestureClass_Struct = packed record
      _type: cuint16;
      len: cuint16;
      sourceid: TDeviceId;
      num_touches: cuint8;
      pad_4: array[0..1-1] of cuint8; // padding
    end;

  // struct ValuatorClass
  type
    TValuatorClass_Struct = packed record
      _type: cuint16;
      len: cuint16;
      sourceid: TDeviceId;
      number: cuint16;
      _label: cuint32;
      min: cuint32;
      max: cuint32;
      value: cuint32;
      resolution: cuint32;
      mode: cuint8;
      pad_10: array[0..3-1] of cuint8; // padding
    end;

  // struct DeviceClass
  type
    TDeviceClass_Struct = packed record
      // length (node index 0) - skipped
      _type: cuint16;
      len: cuint16;
      sourceid: TDeviceId;
      switch_4: Pointer; // switch field - manual handling required
    end;

  // struct XIDeviceInfo
  type
    TXIDeviceInfo_Struct = packed record
      deviceid: TDeviceId;
      _type: cuint16;
      attachment: TDeviceId;
      num_classes: cuint16;
      name_len: cuint16;
      enabled: cuint8;
      pad_6: array[0..1-1] of cuint8; // padding
      list_7: Pointer; // list field
      pad_8: cuint8; // pad (unspecified bytes)
      list_9: Pointer; // list field
    end;

  // struct GrabModifierInfo
  type
    TGrabModifierInfo_Struct = packed record
      modifiers: cuint32;
      status: cuint8;
      pad_2: array[0..3-1] of cuint8; // padding
    end;

  // struct BarrierReleasePointerInfo
  type
    TBarrierReleasePointerInfo_Struct = packed record
      deviceid: TDeviceId;
      pad_1: array[0..2-1] of cuint8; // padding
      barrier: cuint32;
      eventid: cuint32;
    end;

  // struct HierarchyInfo
  type
    THierarchyInfo_Struct = packed record
      deviceid: TDeviceId;
      attachment: TDeviceId;
      _type: cuint8;
      enabled: cuint8;
      pad_4: array[0..2-1] of cuint8; // padding
      flags: cuint32;
    end;

  // event DeviceValuator
  type
    TDeviceValuator_Event = packed record
      device_id: cuint8;
      device_state: cuint16;
      num_valuators: cuint8;
      first_valuator: cuint8;
    end;

  // event DeviceKeyPress
  type
    TDeviceKeyPress_Event = packed record
      detail: cuint8;
      time: cuint32;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: cint16;
      root_y: cint16;
      event_x: cint16;
      event_y: cint16;
      state: cuint16;
      same_screen: cuint8;
      device_id: cuint8;
    end;

  // event DeviceFocusIn
  type
    TDeviceFocusIn_Event = packed record
      detail: cuint8;
      time: cuint32;
      window: TWINDOW;
      mode: cuint8;
      device_id: cuint8;
    end;

  // event DeviceStateNotify
  type
    TDeviceStateNotify_Event = packed record
      device_id: cuint8;
      time: cuint32;
      num_keys: cuint8;
      num_buttons: cuint8;
      num_valuators: cuint8;
      classes_reported: cuint8;
    end;

  // event DeviceMappingNotify
  type
    TDeviceMappingNotify_Event = packed record
      device_id: cuint8;
      request: cuint8;
      first_keycode: TKeyCode;
      count: cuint8;
      time: cuint32;
    end;

  // event ChangeDeviceNotify
  type
    TChangeDeviceNotify_Event = packed record
      device_id: cuint8;
      time: cuint32;
      request: cuint8;
    end;

  // event DeviceKeyStateNotify
  type
    TDeviceKeyStateNotify_Event = packed record
      device_id: cuint8;
    end;

  // event DeviceButtonStateNotify
  type
    TDeviceButtonStateNotify_Event = packed record
      device_id: cuint8;
    end;

  // event DevicePresenceNotify
  type
    TDevicePresenceNotify_Event = packed record
      time: cuint32;
      devchange: cuint8;
      device_id: cuint8;
      control: cuint16;
    end;

  // event DevicePropertyNotify
  type
    TDevicePropertyNotify_Event = packed record
      state: cuint8;
      time: cuint32;
      _property: cuint32;
      device_id: cuint8;
    end;

  // event DeviceChanged
  type
    TDeviceChanged_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      num_classes: cuint16;
      sourceid: TDeviceId;
      reason: cuint8;
    end;

  // event KeyPress
  type
    TKeyPress_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      detail: cuint32;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: TFP1616;
      root_y: TFP1616;
      event_x: TFP1616;
      event_y: TFP1616;
      buttons_len: cuint16;
      valuators_len: cuint16;
      sourceid: TDeviceId;
      flags: cuint32;
      mods: cuint32;
      group: cuint32;
    end;

  // event ButtonPress
  type
    TButtonPress_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      detail: cuint32;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: TFP1616;
      root_y: TFP1616;
      event_x: TFP1616;
      event_y: TFP1616;
      buttons_len: cuint16;
      valuators_len: cuint16;
      sourceid: TDeviceId;
      flags: cuint32;
      mods: cuint32;
      group: cuint32;
    end;

  // event Enter
  type
    TEnter_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      sourceid: TDeviceId;
      mode: cuint8;
      detail: cuint8;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: TFP1616;
      root_y: TFP1616;
      event_x: TFP1616;
      event_y: TFP1616;
      same_screen: cuint8;
      focus: cuint8;
      buttons_len: cuint16;
      mods: cuint32;
      group: cuint32;
    end;

  // event Hierarchy
  type
    THierarchy_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      flags: cuint32;
      num_infos: cuint16;
    end;

  // event Property
  type
    TProperty_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      _property: cuint32;
      what: cuint8;
    end;

  // event RawKeyPress
  type
    TRawKeyPress_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      detail: cuint32;
      sourceid: TDeviceId;
      valuators_len: cuint16;
      flags: cuint32;
    end;

  // event RawButtonPress
  type
    TRawButtonPress_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      detail: cuint32;
      sourceid: TDeviceId;
      valuators_len: cuint16;
      flags: cuint32;
    end;

  // event TouchBegin
  type
    TTouchBegin_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      detail: cuint32;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: TFP1616;
      root_y: TFP1616;
      event_x: TFP1616;
      event_y: TFP1616;
      buttons_len: cuint16;
      valuators_len: cuint16;
      sourceid: TDeviceId;
      flags: cuint32;
      mods: cuint32;
      group: cuint32;
    end;

  // event TouchOwnership
  type
    TTouchOwnership_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      touchid: cuint32;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      sourceid: TDeviceId;
      flags: cuint32;
    end;

  // event RawTouchBegin
  type
    TRawTouchBegin_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      detail: cuint32;
      sourceid: TDeviceId;
      valuators_len: cuint16;
      flags: cuint32;
    end;

  // event BarrierHit
  type
    TBarrierHit_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      eventid: cuint32;
      root: TWINDOW;
      event: TWINDOW;
      barrier: cuint32;
      dtime: cuint32;
      flags: cuint32;
      sourceid: TDeviceId;
      root_x: TFP1616;
      root_y: TFP1616;
      dx: cuint32;
      dy: cuint32;
    end;

  // event GesturePinchBegin
  type
    TGesturePinchBegin_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      detail: cuint32;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: TFP1616;
      root_y: TFP1616;
      event_x: TFP1616;
      event_y: TFP1616;
      delta_x: TFP1616;
      delta_y: TFP1616;
      delta_unaccel_x: TFP1616;
      delta_unaccel_y: TFP1616;
      scale: TFP1616;
      delta_angle: TFP1616;
      sourceid: TDeviceId;
      mods: cuint32;
      group: cuint32;
      flags: cuint32;
    end;

  // event GestureSwipeBegin
  type
    TGestureSwipeBegin_Event = packed record
      deviceid: TDeviceId;
      time: cuint32;
      detail: cuint32;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: TFP1616;
      root_y: TFP1616;
      event_x: TFP1616;
      event_y: TFP1616;
      delta_x: TFP1616;
      delta_y: TFP1616;
      delta_unaccel_x: TFP1616;
      delta_unaccel_y: TFP1616;
      sourceid: TDeviceId;
      mods: cuint32;
      group: cuint32;
      flags: cuint32;
    end;

  // error Device
  type
    TDevice_Error = packed record
    end;

  // error Event
  type
    TEvent_Error = packed record
    end;

  // error Mode
  type
    TMode_Error = packed record
    end;

  // error DeviceBusy
  type
    TDeviceBusy_Error = packed record
    end;

  // error Class
  type
    TClass_Error = packed record
    end;

  // request GetExtensionVersion
  const XCB_GETEXTENSIONVERSION = 1; // opcode
  type
    TGetExtensionVersionReply = packed record
      xi_reply_type: cuint8;
      server_major: cuint16;
      server_minor: cuint16;
      present: cuint8;
    end;

  // request ListInputDevices
  const XCB_LISTINPUTDEVICES = 2; // opcode
  type
    TListInputDevicesReply = packed record
      xi_reply_type: cuint8;
      devices_len: cuint8;
    end;

  // request OpenDevice
  const XCB_OPENDEVICE = 3; // opcode
  type
    TOpenDeviceReply = packed record
      xi_reply_type: cuint8;
      num_classes: cuint8;
    end;

  // request CloseDevice
  const XCB_CLOSEDEVICE = 4; // opcode
  // request SetDeviceMode
  const XCB_SETDEVICEMODE = 5; // opcode
  type
    TSetDeviceModeReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
    end;

  // request SelectExtensionEvent
  const XCB_SELECTEXTENSIONEVENT = 6; // opcode
  // request GetSelectedExtensionEvents
  const XCB_GETSELECTEDEXTENSIONEVENTS = 7; // opcode
  type
    TGetSelectedExtensionEventsReply = packed record
      xi_reply_type: cuint8;
      num_this_classes: cuint16;
      num_all_classes: cuint16;
    end;

  // request ChangeDeviceDontPropagateList
  const XCB_CHANGEDEVICEDONTPROPAGATELIST = 8; // opcode
  // request GetDeviceDontPropagateList
  const XCB_GETDEVICEDONTPROPAGATELIST = 9; // opcode
  type
    TGetDeviceDontPropagateListReply = packed record
      xi_reply_type: cuint8;
      num_classes: cuint16;
    end;

  // request GetDeviceMotionEvents
  const XCB_GETDEVICEMOTIONEVENTS = 10; // opcode
  type
    TGetDeviceMotionEventsReply = packed record
      xi_reply_type: cuint8;
      num_events: cuint32;
      num_axes: cuint8;
      device_mode: cuint8;
    end;

  // request ChangeKeyboardDevice
  const XCB_CHANGEKEYBOARDDEVICE = 11; // opcode
  type
    TChangeKeyboardDeviceReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
    end;

  // request ChangePointerDevice
  const XCB_CHANGEPOINTERDEVICE = 12; // opcode
  type
    TChangePointerDeviceReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
    end;

  // request GrabDevice
  const XCB_GRABDEVICE = 13; // opcode
  type
    TGrabDeviceReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
    end;

  // request UngrabDevice
  const XCB_UNGRABDEVICE = 14; // opcode
  // request GrabDeviceKey
  const XCB_GRABDEVICEKEY = 15; // opcode
  // request UngrabDeviceKey
  const XCB_UNGRABDEVICEKEY = 16; // opcode
  // request GrabDeviceButton
  const XCB_GRABDEVICEBUTTON = 17; // opcode
  // request UngrabDeviceButton
  const XCB_UNGRABDEVICEBUTTON = 18; // opcode
  // request AllowDeviceEvents
  const XCB_ALLOWDEVICEEVENTS = 19; // opcode
  // request GetDeviceFocus
  const XCB_GETDEVICEFOCUS = 20; // opcode
  type
    TGetDeviceFocusReply = packed record
      xi_reply_type: cuint8;
      focus: TWINDOW;
      time: cuint32;
      revert_to: cuint8;
    end;

  // request SetDeviceFocus
  const XCB_SETDEVICEFOCUS = 21; // opcode
  // request GetFeedbackControl
  const XCB_GETFEEDBACKCONTROL = 22; // opcode
  type
    TGetFeedbackControlReply = packed record
      xi_reply_type: cuint8;
      num_feedbacks: cuint16;
    end;

  // request ChangeFeedbackControl
  const XCB_CHANGEFEEDBACKCONTROL = 23; // opcode
  // request GetDeviceKeyMapping
  const XCB_GETDEVICEKEYMAPPING = 24; // opcode
  type
    TGetDeviceKeyMappingReply = packed record
      xi_reply_type: cuint8;
      keysyms_per_keycode: cuint8;
    end;

  // request ChangeDeviceKeyMapping
  const XCB_CHANGEDEVICEKEYMAPPING = 25; // opcode
  // request GetDeviceModifierMapping
  const XCB_GETDEVICEMODIFIERMAPPING = 26; // opcode
  type
    TGetDeviceModifierMappingReply = packed record
      xi_reply_type: cuint8;
      keycodes_per_modifier: cuint8;
    end;

  // request SetDeviceModifierMapping
  const XCB_SETDEVICEMODIFIERMAPPING = 27; // opcode
  type
    TSetDeviceModifierMappingReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
    end;

  // request GetDeviceButtonMapping
  const XCB_GETDEVICEBUTTONMAPPING = 28; // opcode
  type
    TGetDeviceButtonMappingReply = packed record
      xi_reply_type: cuint8;
      map_size: cuint8;
    end;

  // request SetDeviceButtonMapping
  const XCB_SETDEVICEBUTTONMAPPING = 29; // opcode
  type
    TSetDeviceButtonMappingReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
    end;

  // request QueryDeviceState
  const XCB_QUERYDEVICESTATE = 30; // opcode
  type
    TQueryDeviceStateReply = packed record
      xi_reply_type: cuint8;
      num_classes: cuint8;
    end;

  // request DeviceBell
  const XCB_DEVICEBELL = 32; // opcode
  // request SetDeviceValuators
  const XCB_SETDEVICEVALUATORS = 33; // opcode
  type
    TSetDeviceValuatorsReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
    end;

  // request GetDeviceControl
  const XCB_GETDEVICECONTROL = 34; // opcode
  type
    TGetDeviceControlReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
      control: cuint32;
    end;

  // request ChangeDeviceControl
  const XCB_CHANGEDEVICECONTROL = 35; // opcode
  type
    TChangeDeviceControlReply = packed record
      xi_reply_type: cuint8;
      status: cuint8;
    end;

  // request ListDeviceProperties
  const XCB_LISTDEVICEPROPERTIES = 36; // opcode
  type
    TListDevicePropertiesReply = packed record
      xi_reply_type: cuint8;
      num_atoms: cuint16;
    end;

  // request ChangeDeviceProperty
  const XCB_CHANGEDEVICEPROPERTY = 37; // opcode
  // request DeleteDeviceProperty
  const XCB_DELETEDEVICEPROPERTY = 38; // opcode
  // request GetDeviceProperty
  const XCB_GETDEVICEPROPERTY = 39; // opcode
  type
    TGetDevicePropertyReply = packed record
      xi_reply_type: cuint8;
      _type: cuint32;
      bytes_after: cuint32;
      num_items: cuint32;
      format: cuint8;
      device_id: cuint8;
    end;

  // request XIQueryPointer
  const XCB_XIQUERYPOINTER = 40; // opcode
  type
    TXIQueryPointerReply = packed record
      root: TWINDOW;
      child: TWINDOW;
      root_x: TFP1616;
      root_y: TFP1616;
      win_x: TFP1616;
      win_y: TFP1616;
      same_screen: cuint8;
      buttons_len: cuint16;
      mods: cuint32;
      group: cuint32;
    end;

  // request XIWarpPointer
  const XCB_XIWARPPOINTER = 41; // opcode
  // request XIChangeCursor
  const XCB_XICHANGECURSOR = 42; // opcode
  // request XIChangeHierarchy
  const XCB_XICHANGEHIERARCHY = 43; // opcode
  // request XISetClientPointer
  const XCB_XISETCLIENTPOINTER = 44; // opcode
  // request XIGetClientPointer
  const XCB_XIGETCLIENTPOINTER = 45; // opcode
  type
    TXIGetClientPointerReply = packed record
      _set: cuint8;
      deviceid: TDeviceId;
    end;

  // request XISelectEvents
  const XCB_XISELECTEVENTS = 46; // opcode
  // request XIQueryVersion
  const XCB_XIQUERYVERSION = 47; // opcode
  type
    TXIQueryVersionReply = packed record
      major_version: cuint16;
      minor_version: cuint16;
    end;

  // request XIQueryDevice
  const XCB_XIQUERYDEVICE = 48; // opcode
  type
    TXIQueryDeviceReply = packed record
      num_infos: cuint16;
    end;

  // request XISetFocus
  const XCB_XISETFOCUS = 49; // opcode
  // request XIGetFocus
  const XCB_XIGETFOCUS = 50; // opcode
  type
    TXIGetFocusReply = packed record
      focus: TWINDOW;
    end;

  // request XIGrabDevice
  const XCB_XIGRABDEVICE = 51; // opcode
  type
    TXIGrabDeviceReply = packed record
      status: cuint8;
    end;

  // request XIUngrabDevice
  const XCB_XIUNGRABDEVICE = 52; // opcode
  // request XIAllowEvents
  const XCB_XIALLOWEVENTS = 53; // opcode
  // request XIPassiveGrabDevice
  const XCB_XIPASSIVEGRABDEVICE = 54; // opcode
  type
    TXIPassiveGrabDeviceReply = packed record
      num_modifiers: cuint16;
    end;

  // request XIPassiveUngrabDevice
  const XCB_XIPASSIVEUNGRABDEVICE = 55; // opcode
  // request XIListProperties
  const XCB_XILISTPROPERTIES = 56; // opcode
  type
    TXIListPropertiesReply = packed record
      num_properties: cuint16;
    end;

  // request XIChangeProperty
  const XCB_XICHANGEPROPERTY = 57; // opcode
  // request XIDeleteProperty
  const XCB_XIDELETEPROPERTY = 58; // opcode
  // request XIGetProperty
  const XCB_XIGETPROPERTY = 59; // opcode
  type
    TXIGetPropertyReply = packed record
      _type: cuint32;
      bytes_after: cuint32;
      num_items: cuint32;
      format: cuint8;
    end;

  // request XIGetSelectedEvents
  const XCB_XIGETSELECTEDEVENTS = 60; // opcode
  type
    TXIGetSelectedEventsReply = packed record
      num_masks: cuint16;
    end;

  // request XIBarrierReleasePointer
  const XCB_XIBARRIERRELEASEPOINTER = 61; // opcode
  // request SendExtensionEvent
  const XCB_SENDEXTENSIONEVENT = 31; // opcode

implementation

end.
