unit xkb;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from xkb.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // typedef DeviceSpec -> CARD16
  type TDeviceSpec = cuint16;

  // typedef LedClassSpec -> CARD16
  type TLedClassSpec = cuint16;

  // typedef BellClassSpec -> CARD16
  type TBellClassSpec = cuint16;

  // typedef IDSpec -> CARD16
  type TIDSpec = cuint16;

  // typedef LockBehavior -> DefaultBehavior
  type TLockBehavior = cuint32;

  // typedef PermamentLockBehavior -> LockBehavior
  type TPermamentLockBehavior = TLockBehavior;

  // typedef PermamentRadioGroupBehavior -> RadioGroupBehavior
  type TPermamentRadioGroupBehavior = cuint32;

  // typedef PermamentOverlayBehavior -> OverlayBehavior
  type TPermamentOverlayBehavior = cuint32;

  // typedef STRING8 -> char
  type TSTRING8 = cchar;

  // typedef SALatchMods -> SASetMods
  type TSALatchMods = cuint32;

  // typedef SALockMods -> SASetMods
  type TSALockMods = cuint32;

  // typedef SALatchGroup -> SASetGroup
  type TSALatchGroup = cuint32;

  // typedef SALockGroup -> SASetGroup
  type TSALockGroup = cuint32;

  // typedef SALockControls -> SASetControls
  type TSALockControls = cuint32;

  // enum Const
  const Const_MaxLegalKeyCode = 255;
  const Const_PerKeyBitArraySize = 32;
  const Const_KeyNameLength = 4;

  // enum EventType
  const EventType_NewKeyboardNotify = 1;
  const EventType_MapNotify = 2;
  const EventType_StateNotify = 4;
  const EventType_ControlsNotify = 8;
  const EventType_IndicatorStateNotify = 16;
  const EventType_IndicatorMapNotify = 32;
  const EventType_NamesNotify = 64;
  const EventType_CompatMapNotify = 128;
  const EventType_BellNotify = 256;
  const EventType_ActionMessage = 512;
  const EventType_AccessXNotify = 1024;
  const EventType_ExtensionDeviceNotify = 2048;

  // enum NKNDetail
  const NKNDetail_Keycodes = 1;
  const NKNDetail_Geometry = 2;
  const NKNDetail_DeviceID = 4;

  // enum AXNDetail
  const AXNDetail_SKPress = 1;
  const AXNDetail_SKAccept = 2;
  const AXNDetail_SKReject = 4;
  const AXNDetail_SKRelease = 8;
  const AXNDetail_BKAccept = 16;
  const AXNDetail_BKReject = 32;
  const AXNDetail_AXKWarning = 64;

  // enum MapPart
  const MapPart_KeyTypes = 1;
  const MapPart_KeySyms = 2;
  const MapPart_ModifierMap = 4;
  const MapPart_ExplicitComponents = 8;
  const MapPart_KeyActions = 16;
  const MapPart_KeyBehaviors = 32;
  const MapPart_VirtualMods = 64;
  const MapPart_VirtualModMap = 128;

  // enum SetMapFlags
  const SetMapFlags_ResizeTypes = 1;
  const SetMapFlags_RecomputeActions = 2;

  // enum StatePart
  const StatePart_ModifierState = 1;
  const StatePart_ModifierBase = 2;
  const StatePart_ModifierLatch = 4;
  const StatePart_ModifierLock = 8;
  const StatePart_GroupState = 16;
  const StatePart_GroupBase = 32;
  const StatePart_GroupLatch = 64;
  const StatePart_GroupLock = 128;
  const StatePart_CompatState = 256;
  const StatePart_GrabMods = 512;
  const StatePart_CompatGrabMods = 1024;
  const StatePart_LookupMods = 2048;
  const StatePart_CompatLookupMods = 4096;
  const StatePart_PointerButtons = 8192;

  // enum BoolCtrl
  const BoolCtrl_RepeatKeys = 1;
  const BoolCtrl_SlowKeys = 2;
  const BoolCtrl_BounceKeys = 4;
  const BoolCtrl_StickyKeys = 8;
  const BoolCtrl_MouseKeys = 16;
  const BoolCtrl_MouseKeysAccel = 32;
  const BoolCtrl_AccessXKeys = 64;
  const BoolCtrl_AccessXTimeoutMask = 128;
  const BoolCtrl_AccessXFeedbackMask = 256;
  const BoolCtrl_AudibleBellMask = 512;
  const BoolCtrl_Overlay1Mask = 1024;
  const BoolCtrl_Overlay2Mask = 2048;
  const BoolCtrl_IgnoreGroupLockMask = 4096;

  // enum Control
  const Control_GroupsWrap = 134217728;
  const Control_InternalMods = 268435456;
  const Control_IgnoreLockMods = 536870912;
  const Control_PerKeyRepeat = 1073741824;
  const Control_ControlsEnabled = -2147483648;

  // enum AXOption
  const AXOption_SKPressFB = 1;
  const AXOption_SKAcceptFB = 2;
  const AXOption_FeatureFB = 4;
  const AXOption_SlowWarnFB = 8;
  const AXOption_IndicatorFB = 16;
  const AXOption_StickyKeysFB = 32;
  const AXOption_TwoKeys = 64;
  const AXOption_LatchToLock = 128;
  const AXOption_SKReleaseFB = 256;
  const AXOption_SKRejectFB = 512;
  const AXOption_BKRejectFB = 1024;
  const AXOption_DumbBell = 2048;

  // enum LedClassResult
  const LedClassResult_KbdFeedbackClass = 0;
  const LedClassResult_LedFeedbackClass = 4;

  // enum LedClass
  const LedClass_KbdFeedbackClass = 0;
  const LedClass_LedFeedbackClass = 4;
  const LedClass_DfltXIClass = 768;
  const LedClass_AllXIClasses = 1280;

  // enum BellClassResult
  const BellClassResult_KbdFeedbackClass = 0;
  const BellClassResult_BellFeedbackClass = 5;

  // enum BellClass
  const BellClass_KbdFeedbackClass = 0;
  const BellClass_BellFeedbackClass = 5;
  const BellClass_DfltXIClass = 768;

  // enum ID
  const ID_UseCoreKbd = 256;
  const ID_UseCorePtr = 512;
  const ID_DfltXIClass = 768;
  const ID_DfltXIId = 1024;
  const ID_AllXIClass = 1280;
  const ID_AllXIId = 1536;
  const ID_XINone = 65280;

  // enum Group
  const Group_1 = 0;
  const Group_2 = 1;
  const Group_3 = 2;
  const Group_4 = 3;

  // enum Groups
  const Groups_Any = 254;
  const Groups_All = 255;

  // enum SetOfGroup
  const SetOfGroup_Group1 = 1;
  const SetOfGroup_Group2 = 2;
  const SetOfGroup_Group3 = 4;
  const SetOfGroup_Group4 = 8;

  // enum SetOfGroups
  const SetOfGroups_Any = 128;

  // enum GroupsWrap
  const GroupsWrap_WrapIntoRange = 0;
  const GroupsWrap_ClampIntoRange = 64;
  const GroupsWrap_RedirectIntoRange = 128;

  // enum VModsHigh
  const VModsHigh_15 = 128;
  const VModsHigh_14 = 64;
  const VModsHigh_13 = 32;
  const VModsHigh_12 = 16;
  const VModsHigh_11 = 8;
  const VModsHigh_10 = 4;
  const VModsHigh_9 = 2;
  const VModsHigh_8 = 1;

  // enum VModsLow
  const VModsLow_7 = 128;
  const VModsLow_6 = 64;
  const VModsLow_5 = 32;
  const VModsLow_4 = 16;
  const VModsLow_3 = 8;
  const VModsLow_2 = 4;
  const VModsLow_1 = 2;
  const VModsLow_0 = 1;

  // enum VMod
  const VMod_15 = 32768;
  const VMod_14 = 16384;
  const VMod_13 = 8192;
  const VMod_12 = 4096;
  const VMod_11 = 2048;
  const VMod_10 = 1024;
  const VMod_9 = 512;
  const VMod_8 = 256;
  const VMod_7 = 128;
  const VMod_6 = 64;
  const VMod_5 = 32;
  const VMod_4 = 16;
  const VMod_3 = 8;
  const VMod_2 = 4;
  const VMod_1 = 2;
  const VMod_0 = 1;

  // enum Explicit
  const Explicit_VModMap = 128;
  const Explicit_Behavior = 64;
  const Explicit_AutoRepeat = 32;
  const Explicit_Interpret = 16;
  const Explicit_KeyType4 = 8;
  const Explicit_KeyType3 = 4;
  const Explicit_KeyType2 = 2;
  const Explicit_KeyType1 = 1;

  // enum SymInterpretMatch
  const SymInterpretMatch_NoneOf = 0;
  const SymInterpretMatch_AnyOfOrNone = 1;
  const SymInterpretMatch_AnyOf = 2;
  const SymInterpretMatch_AllOf = 3;
  const SymInterpretMatch_Exactly = 4;

  // enum SymInterpMatch
  const SymInterpMatch_LevelOneOnly = 128;
  const SymInterpMatch_OpMask = 127;

  // enum IMFlag
  const IMFlag_NoExplicit = 128;
  const IMFlag_NoAutomatic = 64;
  const IMFlag_LEDDrivesKB = 32;

  // enum IMModsWhich
  const IMModsWhich_UseCompat = 16;
  const IMModsWhich_UseEffective = 8;
  const IMModsWhich_UseLocked = 4;
  const IMModsWhich_UseLatched = 2;
  const IMModsWhich_UseBase = 1;

  // enum IMGroupsWhich
  const IMGroupsWhich_UseCompat = 16;
  const IMGroupsWhich_UseEffective = 8;
  const IMGroupsWhich_UseLocked = 4;
  const IMGroupsWhich_UseLatched = 2;
  const IMGroupsWhich_UseBase = 1;

  // enum CMDetail
  const CMDetail_SymInterp = 1;
  const CMDetail_GroupCompat = 2;

  // enum NameDetail
  const NameDetail_Keycodes = 1;
  const NameDetail_Geometry = 2;
  const NameDetail_Symbols = 4;
  const NameDetail_PhysSymbols = 8;
  const NameDetail_Types = 16;
  const NameDetail_Compat = 32;
  const NameDetail_KeyTypeNames = 64;
  const NameDetail_KTLevelNames = 128;
  const NameDetail_IndicatorNames = 256;
  const NameDetail_KeyNames = 512;
  const NameDetail_KeyAliases = 1024;
  const NameDetail_VirtualModNames = 2048;
  const NameDetail_GroupNames = 4096;
  const NameDetail_RGNames = 8192;

  // enum GBNDetail
  const GBNDetail_Types = 1;
  const GBNDetail_CompatMap = 2;
  const GBNDetail_ClientSymbols = 4;
  const GBNDetail_ServerSymbols = 8;
  const GBNDetail_IndicatorMaps = 16;
  const GBNDetail_KeyNames = 32;
  const GBNDetail_Geometry = 64;
  const GBNDetail_OtherNames = 128;

  // enum XIFeature
  const XIFeature_Keyboards = 1;
  const XIFeature_ButtonActions = 2;
  const XIFeature_IndicatorNames = 4;
  const XIFeature_IndicatorMaps = 8;
  const XIFeature_IndicatorState = 16;

  // enum PerClientFlag
  const PerClientFlag_DetectableAutoRepeat = 1;
  const PerClientFlag_GrabsUseXKBState = 2;
  const PerClientFlag_AutoResetControls = 4;
  const PerClientFlag_LookupStateWhenGrabbed = 8;
  const PerClientFlag_SendEventUsesXKBState = 16;

  // enum BehaviorType
  const BehaviorType_Default = 0;
  const BehaviorType_Lock = 1;
  const BehaviorType_RadioGroup = 2;
  const BehaviorType_Overlay1 = 3;
  const BehaviorType_Overlay2 = 4;
  const BehaviorType_PermamentLock = 129;
  const BehaviorType_PermamentRadioGroup = 130;
  const BehaviorType_PermamentOverlay1 = 131;
  const BehaviorType_PermamentOverlay2 = 132;

  // enum DoodadType
  const DoodadType_Outline = 1;
  const DoodadType_Solid = 2;
  const DoodadType_Text = 3;
  const DoodadType_Indicator = 4;
  const DoodadType_Logo = 5;

  // enum Error
  const Error_BadDevice = 255;
  const Error_BadClass = 254;
  const Error_BadId = 253;

  // enum SA
  const SA_ClearLocks = 1;
  const SA_LatchToLock = 2;
  const SA_UseModMapMods = 4;
  const SA_GroupAbsolute = 4;

  // enum SAType
  const SAType_NoAction = 0;
  const SAType_SetMods = 1;
  const SAType_LatchMods = 2;
  const SAType_LockMods = 3;
  const SAType_SetGroup = 4;
  const SAType_LatchGroup = 5;
  const SAType_LockGroup = 6;
  const SAType_MovePtr = 7;
  const SAType_PtrBtn = 8;
  const SAType_LockPtrBtn = 9;
  const SAType_SetPtrDflt = 10;
  const SAType_ISOLock = 11;
  const SAType_Terminate = 12;
  const SAType_SwitchScreen = 13;
  const SAType_SetControls = 14;
  const SAType_LockControls = 15;
  const SAType_ActionMessage = 16;
  const SAType_RedirectKey = 17;
  const SAType_DeviceBtn = 18;
  const SAType_LockDeviceBtn = 19;
  const SAType_DeviceValuator = 20;

  // enum SAMovePtrFlag
  const SAMovePtrFlag_NoAcceleration = 1;
  const SAMovePtrFlag_MoveAbsoluteX = 2;
  const SAMovePtrFlag_MoveAbsoluteY = 4;

  // enum SASetPtrDfltFlag
  const SASetPtrDfltFlag_DfltBtnAbsolute = 4;
  const SASetPtrDfltFlag_AffectDfltButton = 1;

  // enum SAIsoLockFlag
  const SAIsoLockFlag_NoLock = 1;
  const SAIsoLockFlag_NoUnlock = 2;
  const SAIsoLockFlag_UseModMapMods = 4;
  const SAIsoLockFlag_GroupAbsolute = 4;
  const SAIsoLockFlag_ISODfltIsGroup = 8;

  // enum SAIsoLockNoAffect
  const SAIsoLockNoAffect_Ctrls = 8;
  const SAIsoLockNoAffect_Ptr = 16;
  const SAIsoLockNoAffect_Group = 32;
  const SAIsoLockNoAffect_Mods = 64;

  // enum SwitchScreenFlag
  const SwitchScreenFlag_Application = 1;
  const SwitchScreenFlag_Absolute = 4;

  // enum BoolCtrlsHigh
  const BoolCtrlsHigh_AccessXFeedback = 1;
  const BoolCtrlsHigh_AudibleBell = 2;
  const BoolCtrlsHigh_Overlay1 = 4;
  const BoolCtrlsHigh_Overlay2 = 8;
  const BoolCtrlsHigh_IgnoreGroupLock = 16;

  // enum BoolCtrlsLow
  const BoolCtrlsLow_RepeatKeys = 1;
  const BoolCtrlsLow_SlowKeys = 2;
  const BoolCtrlsLow_BounceKeys = 4;
  const BoolCtrlsLow_StickyKeys = 8;
  const BoolCtrlsLow_MouseKeys = 16;
  const BoolCtrlsLow_MouseKeysAccel = 32;
  const BoolCtrlsLow_AccessXKeys = 64;
  const BoolCtrlsLow_AccessXTimeout = 128;

  // enum ActionMessageFlag
  const ActionMessageFlag_OnPress = 1;
  const ActionMessageFlag_OnRelease = 2;
  const ActionMessageFlag_GenKeyEvent = 4;

  // enum LockDeviceFlags
  const LockDeviceFlags_NoLock = 1;
  const LockDeviceFlags_NoUnlock = 2;

  // enum SAValWhat
  const SAValWhat_IgnoreVal = 0;
  const SAValWhat_SetValMin = 1;
  const SAValWhat_SetValCenter = 2;
  const SAValWhat_SetValMax = 3;
  const SAValWhat_SetValRelative = 4;
  const SAValWhat_SetValAbsolute = 5;

  // struct IndicatorMap
  type
    TIndicatorMap_Struct = packed record
      flags: cuint8;
      whichGroups: cuint8;
      groups: cuint8;
      whichMods: cuint8;
      mods: cuint8;
      realMods: cuint8;
      vmods: cuint16;
      ctrls: cuint32;
    end;

  // struct ModDef
  type
    TModDef_Struct = packed record
      mask: cuint8;
      realMods: cuint8;
      vmods: cuint16;
    end;

  // struct KeyName
  type
    TKeyName_Struct = packed record
      list_0: Pointer; // list field
    end;

  // struct KeyAlias
  type
    TKeyAlias_Struct = packed record
      list_0: Pointer; // list field
      list_1: Pointer; // list field
    end;

  // struct CountedString16
  type
    TCountedString16_Struct = packed record
      length: cuint16;
      list_1: Pointer; // list field
      list_2: Pointer; // list field
    end;

  // struct KTMapEntry
  type
    TKTMapEntry_Struct = packed record
      active: cuint8;
      mods_mask: cuint8;
      level: cuint8;
      mods_mods: cuint8;
      mods_vmods: cuint16;
      pad_5: array[0..2-1] of cuint8; // padding
    end;

  // struct KeyType
  type
    TKeyType_Struct = packed record
      mods_mask: cuint8;
      mods_mods: cuint8;
      mods_vmods: cuint16;
      numLevels: cuint8;
      nMapEntries: cuint8;
      hasPreserve: cuint8;
      pad_6: array[0..1-1] of cuint8; // padding
      list_7: Pointer; // list field
      list_8: Pointer; // list field
    end;

  // struct KeySymMap
  type
    TKeySymMap_Struct = packed record
      list_0: Pointer; // list field
      groupInfo: cuint8;
      width: cuint8;
      nSyms: cuint16;
      list_4: Pointer; // list field
    end;

  // struct CommonBehavior
  type
    TCommonBehavior_Struct = packed record
      _type: cuint8;
      data: cuint8;
    end;

  // struct DefaultBehavior
  type
    TDefaultBehavior_Struct = packed record
      _type: cuint8;
      pad_1: array[0..1-1] of cuint8; // padding
    end;

  // struct RadioGroupBehavior
  type
    TRadioGroupBehavior_Struct = packed record
      _type: cuint8;
      group: cuint8;
    end;

  // struct OverlayBehavior
  type
    TOverlayBehavior_Struct = packed record
      _type: cuint8;
      key: TKEYCODE;
    end;

  // struct SetBehavior
  type
    TSetBehavior_Struct = packed record
      keycode: TKEYCODE;
      behavior: cuint32;
      pad_2: array[0..1-1] of cuint8; // padding
    end;

  // struct SetExplicit
  type
    TSetExplicit_Struct = packed record
      keycode: TKEYCODE;
      explicit: cuint8;
    end;

  // struct KeyModMap
  type
    TKeyModMap_Struct = packed record
      keycode: TKEYCODE;
      mods: cuint8;
    end;

  // struct KeyVModMap
  type
    TKeyVModMap_Struct = packed record
      keycode: TKEYCODE;
      pad_1: array[0..1-1] of cuint8; // padding
      vmods: cuint16;
    end;

  // struct KTSetMapEntry
  type
    TKTSetMapEntry_Struct = packed record
      level: cuint8;
      realMods: cuint8;
      virtualMods: cuint16;
    end;

  // struct SetKeyType
  type
    TSetKeyType_Struct = packed record
      mask: cuint8;
      realMods: cuint8;
      virtualMods: cuint16;
      numLevels: cuint8;
      nMapEntries: cuint8;
      preserve: cuint8;
      pad_6: array[0..1-1] of cuint8; // padding
      list_7: Pointer; // list field
      list_8: Pointer; // list field
    end;

  // struct Outline
  type
    TOutline_Struct = packed record
      nPoints: cuint8;
      cornerRadius: cuint8;
      pad_2: array[0..2-1] of cuint8; // padding
      list_3: Pointer; // list field
    end;

  // struct Shape
  type
    TShape_Struct = packed record
      name: cuint32;
      nOutlines: cuint8;
      primaryNdx: cuint8;
      approxNdx: cuint8;
      pad_4: array[0..1-1] of cuint8; // padding
      list_5: Pointer; // list field
    end;

  // struct Key
  type
    TKey_Struct = packed record
      list_0: Pointer; // list field
      gap: cint16;
      shapeNdx: cuint8;
      colorNdx: cuint8;
    end;

  // struct OverlayKey
  type
    TOverlayKey_Struct = packed record
      list_0: Pointer; // list field
      list_1: Pointer; // list field
    end;

  // struct OverlayRow
  type
    TOverlayRow_Struct = packed record
      rowUnder: cuint8;
      nKeys: cuint8;
      pad_2: array[0..2-1] of cuint8; // padding
      list_3: Pointer; // list field
    end;

  // struct Overlay
  type
    TOverlay_Struct = packed record
      name: cuint32;
      nRows: cuint8;
      pad_2: array[0..3-1] of cuint8; // padding
      list_3: Pointer; // list field
    end;

  // struct Row
  type
    TRow_Struct = packed record
      top: cint16;
      left: cint16;
      nKeys: cuint8;
      vertical: cuint8;
      pad_4: array[0..2-1] of cuint8; // padding
      list_5: Pointer; // list field
    end;

  // struct Listing
  type
    TListing_Struct = packed record
      flags: cuint16;
      length: cuint16;
      list_2: Pointer; // list field
      pad_3: cuint8; // pad (unspecified bytes)
    end;

  // struct DeviceLedInfo
  type
    TDeviceLedInfo_Struct = packed record
      ledClass: TLedClassSpec;
      ledID: TIDSpec;
      namesPresent: cuint32;
      mapsPresent: cuint32;
      physIndicators: cuint32;
      state: cuint32;
      list_6: Pointer; // list field
      list_7: Pointer; // list field
    end;

  // struct SANoAction
  type
    TSANoAction_Struct = packed record
      _type: cuint8;
      pad_1: array[0..7-1] of cuint8; // padding
    end;

  // struct SASetMods
  type
    TSASetMods_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      mask: cuint8;
      realMods: cuint8;
      vmodsHigh: cuint8;
      vmodsLow: cuint8;
      pad_6: array[0..2-1] of cuint8; // padding
    end;

  // struct SASetGroup
  type
    TSASetGroup_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      group: cint8;
      pad_3: array[0..5-1] of cuint8; // padding
    end;

  // struct SAMovePtr
  type
    TSAMovePtr_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      xHigh: cint8;
      xLow: cuint8;
      yHigh: cint8;
      yLow: cuint8;
      pad_6: array[0..2-1] of cuint8; // padding
    end;

  // struct SAPtrBtn
  type
    TSAPtrBtn_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      count: cuint8;
      button: cuint8;
      pad_4: array[0..4-1] of cuint8; // padding
    end;

  // struct SALockPtrBtn
  type
    TSALockPtrBtn_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      pad_2: array[0..1-1] of cuint8; // padding
      button: cuint8;
      pad_4: array[0..4-1] of cuint8; // padding
    end;

  // struct SASetPtrDflt
  type
    TSASetPtrDflt_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      affect: cuint8;
      value: cint8;
      pad_4: array[0..4-1] of cuint8; // padding
    end;

  // struct SAIsoLock
  type
    TSAIsoLock_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      mask: cuint8;
      realMods: cuint8;
      group: cint8;
      affect: cuint8;
      vmodsHigh: cuint8;
      vmodsLow: cuint8;
    end;

  // struct SATerminate
  type
    TSATerminate_Struct = packed record
      _type: cuint8;
      pad_1: array[0..7-1] of cuint8; // padding
    end;

  // struct SASwitchScreen
  type
    TSASwitchScreen_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      newScreen: cint8;
      pad_3: array[0..5-1] of cuint8; // padding
    end;

  // struct SASetControls
  type
    TSASetControls_Struct = packed record
      _type: cuint8;
      pad_1: array[0..3-1] of cuint8; // padding
      boolCtrlsHigh: cuint8;
      boolCtrlsLow: cuint8;
      pad_4: array[0..2-1] of cuint8; // padding
    end;

  // struct SAActionMessage
  type
    TSAActionMessage_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      list_2: Pointer; // list field
    end;

  // struct SARedirectKey
  type
    TSARedirectKey_Struct = packed record
      _type: cuint8;
      newkey: TKEYCODE;
      mask: cuint8;
      realModifiers: cuint8;
      vmodsMaskHigh: cuint8;
      vmodsMaskLow: cuint8;
      vmodsHigh: cuint8;
      vmodsLow: cuint8;
    end;

  // struct SADeviceBtn
  type
    TSADeviceBtn_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      count: cuint8;
      button: cuint8;
      device: cuint8;
      pad_5: array[0..3-1] of cuint8; // padding
    end;

  // struct SALockDeviceBtn
  type
    TSALockDeviceBtn_Struct = packed record
      _type: cuint8;
      flags: cuint8;
      pad_2: array[0..1-1] of cuint8; // padding
      button: cuint8;
      device: cuint8;
      pad_5: array[0..3-1] of cuint8; // padding
    end;

  // struct SADeviceValuator
  type
    TSADeviceValuator_Struct = packed record
      _type: cuint8;
      device: cuint8;
      val1what: cuint8;
      val1index: cuint8;
      val1value: cuint8;
      val2what: cuint8;
      val2index: cuint8;
      val2value: cuint8;
    end;

  // struct SIAction
  type
    TSIAction_Struct = packed record
      _type: cuint8;
      list_1: Pointer; // list field
    end;

  // struct SymInterpret
  type
    TSymInterpret_Struct = packed record
      sym: cuint32;
      mods: cuint8;
      // #comment (node index 2) - skipped
      match: cuint8;
      virtualMod: cuint8;
      flags: cuint8;
      action: cuint32;
    end;

  // union Behavior
  type
    TBehavior_Union = packed record
      case Integer of
        0: (common: cuint32);
        1: (default: cuint32);
        2: (lock: TLockBehavior);
        3: (radioGroup: cuint32);
        4: (overlay1: cuint32);
        5: (overlay2: cuint32);
        6: (permamentLock: TPermamentLockBehavior);
        7: (permamentRadioGroup: TPermamentRadioGroupBehavior);
        8: (permamentOverlay1: TPermamentOverlayBehavior);
        9: (permamentOverlay2: TPermamentOverlayBehavior);
        10: (_type: cuint8);
    end;

  // union Action
  type
    TAction_Union = packed record
      case Integer of
        0: (noaction: cuint32);
        1: (setmods: cuint32);
        2: (latchmods: TSALatchMods);
        3: (lockmods: TSALockMods);
        4: (setgroup: cuint32);
        5: (latchgroup: TSALatchGroup);
        6: (lockgroup: TSALockGroup);
        7: (moveptr: cuint32);
        8: (ptrbtn: cuint32);
        9: (lockptrbtn: cuint32);
        10: (setptrdflt: cuint32);
        11: (isolock: cuint32);
        12: (terminate: cuint32);
        13: (switchscreen: cuint32);
        14: (setcontrols: cuint32);
        15: (lockcontrols: TSALockControls);
        16: (message: cuint32);
        17: (redirect: cuint32);
        18: (devbtn: cuint32);
        19: (lockdevbtn: cuint32);
        20: (devval: cuint32);
        21: (_type: cuint8);
    end;

  // event NewKeyboardNotify
  type
    TNewKeyboardNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      oldDeviceID: cuint8;
      minKeyCode: TKEYCODE;
      maxKeyCode: TKEYCODE;
      oldMinKeyCode: TKEYCODE;
      oldMaxKeyCode: TKEYCODE;
      requestMajor: cuint8;
      requestMinor: cuint8;
      changed: cuint16;
    end;

  // event MapNotify
  type
    TMapNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      ptrBtnActions: cuint8;
      changed: cuint16;
      minKeyCode: TKEYCODE;
      maxKeyCode: TKEYCODE;
      firstType: cuint8;
      nTypes: cuint8;
      firstKeySym: TKEYCODE;
      nKeySyms: cuint8;
      firstKeyAct: TKEYCODE;
      nKeyActs: cuint8;
      firstKeyBehavior: TKEYCODE;
      nKeyBehavior: cuint8;
      firstKeyExplicit: TKEYCODE;
      nKeyExplicit: cuint8;
      firstModMapKey: TKEYCODE;
      nModMapKeys: cuint8;
      firstVModMapKey: TKEYCODE;
      nVModMapKeys: cuint8;
      virtualMods: cuint16;
    end;

  // event StateNotify
  type
    TStateNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      mods: cuint8;
      baseMods: cuint8;
      latchedMods: cuint8;
      lockedMods: cuint8;
      group: cuint8;
      baseGroup: cint16;
      latchedGroup: cint16;
      lockedGroup: cuint8;
      compatState: cuint8;
      grabMods: cuint8;
      compatGrabMods: cuint8;
      lookupMods: cuint8;
      compatLoockupMods: cuint8;
      ptrBtnState: cuint16;
      changed: cuint16;
      keycode: TKEYCODE;
      eventType: cuint8;
      requestMajor: cuint8;
      requestMinor: cuint8;
    end;

  // event ControlsNotify
  type
    TControlsNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      numGroups: cuint8;
      changedControls: cuint32;
      enabledControls: cuint32;
      enabledControlChanges: cuint32;
      keycode: TKEYCODE;
      eventType: cuint8;
      requestMajor: cuint8;
      requestMinor: cuint8;
    end;

  // event IndicatorStateNotify
  type
    TIndicatorStateNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      state: cuint32;
      stateChanged: cuint32;
    end;

  // event IndicatorMapNotify
  type
    TIndicatorMapNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      state: cuint32;
      mapChanged: cuint32;
    end;

  // event NamesNotify
  type
    TNamesNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      changed: cuint16;
      firstType: cuint8;
      nTypes: cuint8;
      firstLevelName: cuint8;
      nLevelNames: cuint8;
      nRadioGroups: cuint8;
      nKeyAliases: cuint8;
      changedGroupNames: cuint8;
      changedVirtualMods: cuint16;
      firstKey: TKEYCODE;
      nKeys: cuint8;
      changedIndicators: cuint32;
    end;

  // event CompatMapNotify
  type
    TCompatMapNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      changedGroups: cuint8;
      firstSI: cuint16;
      nSI: cuint16;
      nTotalSI: cuint16;
    end;

  // event BellNotify
  type
    TBellNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      bellClass: cuint8;
      bellID: cuint8;
      percent: cuint8;
      pitch: cuint16;
      duration: cuint16;
      name: cuint32;
      window: TWINDOW;
      eventOnly: cuint8;
    end;

  // event ActionMessage
  type
    TActionMessage_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      keycode: TKEYCODE;
      press: cuint8;
      keyEventFollows: cuint8;
      mods: cuint8;
      group: cuint8;
    end;

  // event AccessXNotify
  type
    TAccessXNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      keycode: TKEYCODE;
      detailt: cuint16;
      slowKeysDelay: cuint16;
      debounceDelay: cuint16;
    end;

  // event ExtensionDeviceNotify
  type
    TExtensionDeviceNotify_Event = packed record
      xkbType: cuint8;
      time: cuint32;
      deviceID: cuint8;
      reason: cuint16;
      ledClass: cuint16;
      ledID: cuint16;
      ledsDefined: cuint32;
      ledState: cuint32;
      firstButton: cuint8;
      nButtons: cuint8;
      supported: cuint16;
      unsupported: cuint16;
    end;

  // error Keyboard
  type
    TKeyboard_Error = packed record
      value: cuint32;
      minorOpcode: cuint16;
      majorOpcode: cuint8;
    end;

  // request UseExtension
  const XCB_USEEXTENSION = 0; // opcode
  type
    TUseExtensionReply = packed record
      supported: cuint8;
      serverMajor: cuint16;
      serverMinor: cuint16;
    end;

  // request SelectEvents
  const XCB_SELECTEVENTS = 1; // opcode
  // request Bell
  const XCB_BELL = 3; // opcode
  // request GetState
  const XCB_GETSTATE = 4; // opcode
  type
    TGetStateReply = packed record
      deviceID: cuint8;
      mods: cuint8;
      baseMods: cuint8;
      latchedMods: cuint8;
      lockedMods: cuint8;
      group: cuint8;
      lockedGroup: cuint8;
      baseGroup: cint16;
      latchedGroup: cint16;
      compatState: cuint8;
      grabMods: cuint8;
      compatGrabMods: cuint8;
      lookupMods: cuint8;
      compatLookupMods: cuint8;
      ptrBtnState: cuint16;
    end;

  // request LatchLockState
  const XCB_LATCHLOCKSTATE = 5; // opcode
  // request GetControls
  const XCB_GETCONTROLS = 6; // opcode
  type
    TGetControlsReply = packed record
      deviceID: cuint8;
      mouseKeysDfltBtn: cuint8;
      numGroups: cuint8;
      groupsWrap: cuint8;
      internalModsMask: cuint8;
      ignoreLockModsMask: cuint8;
      internalModsRealMods: cuint8;
      ignoreLockModsRealMods: cuint8;
      internalModsVmods: cuint16;
      ignoreLockModsVmods: cuint16;
      repeatDelay: cuint16;
      repeatInterval: cuint16;
      slowKeysDelay: cuint16;
      debounceDelay: cuint16;
      mouseKeysDelay: cuint16;
      mouseKeysInterval: cuint16;
      mouseKeysTimeToMax: cuint16;
      mouseKeysMaxSpeed: cuint16;
      mouseKeysCurve: cint16;
      accessXOption: cuint16;
      accessXTimeout: cuint16;
      accessXTimeoutOptionsMask: cuint16;
      accessXTimeoutOptionsValues: cuint16;
      accessXTimeoutMask: cuint32;
      accessXTimeoutValues: cuint32;
      enabledControls: cuint32;
    end;

  // request SetControls
  const XCB_SETCONTROLS = 7; // opcode
  // request GetMap
  const XCB_GETMAP = 8; // opcode
  type
    TGetMapReply = packed record
      deviceID: cuint8;
      minKeyCode: TKEYCODE;
      maxKeyCode: TKEYCODE;
      present: cuint16;
      firstType: cuint8;
      nTypes: cuint8;
      totalTypes: cuint8;
      firstKeySym: TKEYCODE;
      totalSyms: cuint16;
      nKeySyms: cuint8;
      firstKeyAction: TKEYCODE;
      totalActions: cuint16;
      nKeyActions: cuint8;
      firstKeyBehavior: TKEYCODE;
      nKeyBehaviors: cuint8;
      totalKeyBehaviors: cuint8;
      firstKeyExplicit: TKEYCODE;
      nKeyExplicit: cuint8;
      totalKeyExplicit: cuint8;
      firstModMapKey: TKEYCODE;
      nModMapKeys: cuint8;
      totalModMapKeys: cuint8;
      firstVModMapKey: TKEYCODE;
      nVModMapKeys: cuint8;
      totalVModMapKeys: cuint8;
      virtualMods: cuint16;
    end;

  // request SetMap
  const XCB_SETMAP = 9; // opcode
  // request GetCompatMap
  const XCB_GETCOMPATMAP = 10; // opcode
  type
    TGetCompatMapReply = packed record
      deviceID: cuint8;
      groupsRtrn: cuint8;
      firstSIRtrn: cuint16;
      nSIRtrn: cuint16;
      nTotalSI: cuint16;
    end;

  // request SetCompatMap
  const XCB_SETCOMPATMAP = 11; // opcode
  // request GetIndicatorState
  const XCB_GETINDICATORSTATE = 12; // opcode
  type
    TGetIndicatorStateReply = packed record
      deviceID: cuint8;
      state: cuint32;
    end;

  // request GetIndicatorMap
  const XCB_GETINDICATORMAP = 13; // opcode
  type
    TGetIndicatorMapReply = packed record
      deviceID: cuint8;
      which: cuint32;
      realIndicators: cuint32;
      nIndicators: cuint8;
    end;

  // request SetIndicatorMap
  const XCB_SETINDICATORMAP = 14; // opcode
  // request GetNamedIndicator
  const XCB_GETNAMEDINDICATOR = 15; // opcode
  type
    TGetNamedIndicatorReply = packed record
      deviceID: cuint8;
      indicator: cuint32;
      found: cuint8;
      on: cuint8;
      realIndicator: cuint8;
      ndx: cuint8;
      map_flags: cuint8;
      map_whichGroups: cuint8;
      map_groups: cuint8;
      map_whichMods: cuint8;
      map_mods: cuint8;
      map_realMods: cuint8;
      map_vmod: cuint16;
      map_ctrls: cuint32;
      supported: cuint8;
    end;

  // request SetNamedIndicator
  const XCB_SETNAMEDINDICATOR = 16; // opcode
  // request GetNames
  const XCB_GETNAMES = 17; // opcode
  type
    TGetNamesReply = packed record
      deviceID: cuint8;
      which: cuint32;
      minKeyCode: TKEYCODE;
      maxKeyCode: TKEYCODE;
      nTypes: cuint8;
      groupNames: cuint8;
      virtualMods: cuint16;
      firstKey: TKEYCODE;
      nKeys: cuint8;
      indicators: cuint32;
      nRadioGroups: cuint8;
      nKeyAliases: cuint8;
      nKTLevels: cuint16;
    end;

  // request SetNames
  const XCB_SETNAMES = 18; // opcode
  // request PerClientFlags
  const XCB_PERCLIENTFLAGS = 21; // opcode
  type
    TPerClientFlagsReply = packed record
      deviceID: cuint8;
      supported: cuint32;
      value: cuint32;
      autoCtrls: cuint32;
      autoCtrlsValues: cuint32;
    end;

  // request ListComponents
  const XCB_LISTCOMPONENTS = 22; // opcode
  type
    TListComponentsReply = packed record
      deviceID: cuint8;
      nKeymaps: cuint16;
      nKeycodes: cuint16;
      nTypes: cuint16;
      nCompatMaps: cuint16;
      nSymbols: cuint16;
      nGeometries: cuint16;
      extra: cuint16;
    end;

  // request GetKbdByName
  const XCB_GETKBDBYNAME = 23; // opcode
  type
    TGetKbdByNameReply = packed record
      deviceID: cuint8;
      minKeyCode: TKEYCODE;
      maxKeyCode: TKEYCODE;
      loaded: cuint8;
      newKeyboard: cuint8;
      found: cuint16;
      reported: cuint16;
    end;

  // request GetDeviceInfo
  const XCB_GETDEVICEINFO = 24; // opcode
  type
    TGetDeviceInfoReply = packed record
      deviceID: cuint8;
      present: cuint16;
      supported: cuint16;
      unsupported: cuint16;
      nDeviceLedFBs: cuint16;
      firstBtnWanted: cuint8;
      nBtnsWanted: cuint8;
      firstBtnRtrn: cuint8;
      nBtnsRtrn: cuint8;
      totalBtns: cuint8;
      hasOwnState: cuint8;
      dfltKbdFB: cuint16;
      dfltLedFB: cuint16;
      devType: cuint32;
      nameLen: cuint16;
    end;

  // request SetDeviceInfo
  const XCB_SETDEVICEINFO = 25; // opcode
  // request SetDebuggingFlags
  const XCB_SETDEBUGGINGFLAGS = 101; // opcode
  type
    TSetDebuggingFlagsReply = packed record
      currentFlags: cuint32;
      currentCtrls: cuint32;
      supportedFlags: cuint32;
      supportedCtrls: cuint32;
    end;


implementation

end.
