unit xproto;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from xproto.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // xidtype WINDOW
  type TWINDOW = cuint32;

  // xidtype PIXMAP
  type TPIXMAP = cuint32;

  // xidtype CURSOR
  type TCURSOR = cuint32;

  // xidtype FONT
  type TFONT = cuint32;

  // xidtype GCONTEXT
  type TGCONTEXT = cuint32;

  // xidtype COLORMAP
  type TCOLORMAP = cuint32;

  // xidtype ATOM
  type TATOM = cuint32;

  // typedef BOOL32 -> CARD32
  type TBOOL32 = cuint32;

  // typedef VISUALID -> CARD32
  type TVISUALID = cuint32;

  // typedef TIMESTAMP -> CARD32
  type TTIMESTAMP = cuint32;

  // typedef KEYSYM -> CARD32
  type TKEYSYM = cuint32;

  // typedef KEYCODE -> CARD8
  type TKEYCODE = cuint8;

  // typedef KEYCODE32 -> CARD32
  type TKEYCODE32 = cuint32;

  // typedef BUTTON -> CARD8
  type TBUTTON = cuint8;

  // enum VisualClass
  const VisualClass_StaticGray = 0;
  const VisualClass_GrayScale = 1;
  const VisualClass_StaticColor = 2;
  const VisualClass_PseudoColor = 3;
  const VisualClass_TrueColor = 4;
  const VisualClass_DirectColor = 5;

  // enum EventMask
  const EventMask_NoEvent = 0;
  const EventMask_KeyPress = 1;
  const EventMask_KeyRelease = 2;
  const EventMask_ButtonPress = 4;
  const EventMask_ButtonRelease = 8;
  const EventMask_EnterWindow = 16;
  const EventMask_LeaveWindow = 32;
  const EventMask_PointerMotion = 64;
  const EventMask_PointerMotionHint = 128;
  const EventMask_Button1Motion = 256;
  const EventMask_Button2Motion = 512;
  const EventMask_Button3Motion = 1024;
  const EventMask_Button4Motion = 2048;
  const EventMask_Button5Motion = 4096;
  const EventMask_ButtonMotion = 8192;
  const EventMask_KeymapState = 16384;
  const EventMask_Exposure = 32768;
  const EventMask_VisibilityChange = 65536;
  const EventMask_StructureNotify = 131072;
  const EventMask_ResizeRedirect = 262144;
  const EventMask_SubstructureNotify = 524288;
  const EventMask_SubstructureRedirect = 1048576;
  const EventMask_FocusChange = 2097152;
  const EventMask_PropertyChange = 4194304;
  const EventMask_ColorMapChange = 8388608;
  const EventMask_OwnerGrabButton = 16777216;

  // enum BackingStore
  const BackingStore_NotUseful = 0;
  const BackingStore_WhenMapped = 1;
  const BackingStore_Always = 2;

  // enum ImageOrder
  const ImageOrder_LSBFirst = 0;
  const ImageOrder_MSBFirst = 1;

  // enum ModMask
  const ModMask_Shift = 1;
  const ModMask_Lock = 2;
  const ModMask_Control = 4;
  const ModMask_1 = 8;
  const ModMask_2 = 16;
  const ModMask_3 = 32;
  const ModMask_4 = 64;
  const ModMask_5 = 128;
  const ModMask_Any = 32768;

  // enum KeyButMask
  const KeyButMask_Shift = 1;
  const KeyButMask_Lock = 2;
  const KeyButMask_Control = 4;
  const KeyButMask_Mod1 = 8;
  const KeyButMask_Mod2 = 16;
  const KeyButMask_Mod3 = 32;
  const KeyButMask_Mod4 = 64;
  const KeyButMask_Mod5 = 128;
  const KeyButMask_Button1 = 256;
  const KeyButMask_Button2 = 512;
  const KeyButMask_Button3 = 1024;
  const KeyButMask_Button4 = 2048;
  const KeyButMask_Button5 = 4096;

  // enum Window
  const Window_None = 0;

  // enum ButtonMask
  const ButtonMask_1 = 256;
  const ButtonMask_2 = 512;
  const ButtonMask_3 = 1024;
  const ButtonMask_4 = 2048;
  const ButtonMask_5 = 4096;
  const ButtonMask_Any = 32768;

  // enum Motion
  const Motion_Normal = 0;
  const Motion_Hint = 1;

  // enum NotifyDetail
  const NotifyDetail_Ancestor = 0;
  const NotifyDetail_Virtual = 1;
  const NotifyDetail_Inferior = 2;
  const NotifyDetail_Nonlinear = 3;
  const NotifyDetail_NonlinearVirtual = 4;
  const NotifyDetail_Pointer = 5;
  const NotifyDetail_PointerRoot = 6;
  const NotifyDetail_None = 7;

  // enum NotifyMode
  const NotifyMode_Normal = 0;
  const NotifyMode_Grab = 1;
  const NotifyMode_Ungrab = 2;
  const NotifyMode_WhileGrabbed = 3;

  // enum Visibility
  const Visibility_Unobscured = 0;
  const Visibility_PartiallyObscured = 1;
  const Visibility_FullyObscured = 2;

  // enum Place
  const Place_OnTop = 0;
  const Place_OnBottom = 1;

  // enum Property
  const Property_NewValue = 0;
  const Property_Delete = 1;

  // enum Time
  const Time_CurrentTime = 0;

  // enum Atom
  const Atom_None = 0;
  const Atom_Any = 0;
  const Atom_PRIMARY = 1;
  const Atom_SECONDARY = 2;
  const Atom_ARC = 3;
  const Atom_ATOM = 4;
  const Atom_BITMAP = 5;
  const Atom_CARDINAL = 6;
  const Atom_COLORMAP = 7;
  const Atom_CURSOR = 8;
  const Atom_CUT_BUFFER0 = 9;
  const Atom_CUT_BUFFER1 = 10;
  const Atom_CUT_BUFFER2 = 11;
  const Atom_CUT_BUFFER3 = 12;
  const Atom_CUT_BUFFER4 = 13;
  const Atom_CUT_BUFFER5 = 14;
  const Atom_CUT_BUFFER6 = 15;
  const Atom_CUT_BUFFER7 = 16;
  const Atom_DRAWABLE = 17;
  const Atom_FONT = 18;
  const Atom_INTEGER = 19;
  const Atom_PIXMAP = 20;
  const Atom_POINT = 21;
  const Atom_RECTANGLE = 22;
  const Atom_RESOURCE_MANAGER = 23;
  const Atom_RGB_COLOR_MAP = 24;
  const Atom_RGB_BEST_MAP = 25;
  const Atom_RGB_BLUE_MAP = 26;
  const Atom_RGB_DEFAULT_MAP = 27;
  const Atom_RGB_GRAY_MAP = 28;
  const Atom_RGB_GREEN_MAP = 29;
  const Atom_RGB_RED_MAP = 30;
  const Atom_STRING = 31;
  const Atom_VISUALID = 32;
  const Atom_WINDOW = 33;
  const Atom_WM_COMMAND = 34;
  const Atom_WM_HINTS = 35;
  const Atom_WM_CLIENT_MACHINE = 36;
  const Atom_WM_ICON_NAME = 37;
  const Atom_WM_ICON_SIZE = 38;
  const Atom_WM_NAME = 39;
  const Atom_WM_NORMAL_HINTS = 40;
  const Atom_WM_SIZE_HINTS = 41;
  const Atom_WM_ZOOM_HINTS = 42;
  const Atom_MIN_SPACE = 43;
  const Atom_NORM_SPACE = 44;
  const Atom_MAX_SPACE = 45;
  const Atom_END_SPACE = 46;
  const Atom_SUPERSCRIPT_X = 47;
  const Atom_SUPERSCRIPT_Y = 48;
  const Atom_SUBSCRIPT_X = 49;
  const Atom_SUBSCRIPT_Y = 50;
  const Atom_UNDERLINE_POSITION = 51;
  const Atom_UNDERLINE_THICKNESS = 52;
  const Atom_STRIKEOUT_ASCENT = 53;
  const Atom_STRIKEOUT_DESCENT = 54;
  const Atom_ITALIC_ANGLE = 55;
  const Atom_X_HEIGHT = 56;
  const Atom_QUAD_WIDTH = 57;
  const Atom_WEIGHT = 58;
  const Atom_POINT_SIZE = 59;
  const Atom_RESOLUTION = 60;
  const Atom_COPYRIGHT = 61;
  const Atom_NOTICE = 62;
  const Atom_FONT_NAME = 63;
  const Atom_FAMILY_NAME = 64;
  const Atom_FULL_NAME = 65;
  const Atom_CAP_HEIGHT = 66;
  const Atom_WM_CLASS = 67;
  const Atom_WM_TRANSIENT_FOR = 68;

  // enum ColormapState
  const ColormapState_Uninstalled = 0;
  const ColormapState_Installed = 1;

  // enum Colormap
  const Colormap_None = 0;

  // enum Mapping
  const Mapping_Modifier = 0;
  const Mapping_Keyboard = 1;
  const Mapping_Pointer = 2;

  // enum WindowClass
  const WindowClass_CopyFromParent = 0;
  const WindowClass_InputOutput = 1;
  const WindowClass_InputOnly = 2;

  // enum CW
  const CW_BackPixmap = 1;
  const CW_BackPixel = 2;
  const CW_BorderPixmap = 4;
  const CW_BorderPixel = 8;
  const CW_BitGravity = 16;
  const CW_WinGravity = 32;
  const CW_BackingStore = 64;
  const CW_BackingPlanes = 128;
  const CW_BackingPixel = 256;
  const CW_OverrideRedirect = 512;
  const CW_SaveUnder = 1024;
  const CW_EventMask = 2048;
  const CW_DontPropagate = 4096;
  const CW_Colormap = 8192;
  const CW_Cursor = 16384;

  // enum BackPixmap
  const BackPixmap_None = 0;
  const BackPixmap_ParentRelative = 1;

  // enum Gravity
  const Gravity_BitForget = 0;
  const Gravity_WinUnmap = 0;
  const Gravity_NorthWest = 1;
  const Gravity_North = 2;
  const Gravity_NorthEast = 3;
  const Gravity_West = 4;
  const Gravity_Center = 5;
  const Gravity_East = 6;
  const Gravity_SouthWest = 7;
  const Gravity_South = 8;
  const Gravity_SouthEast = 9;
  const Gravity_Static = 10;

  // enum MapState
  const MapState_Unmapped = 0;
  const MapState_Unviewable = 1;
  const MapState_Viewable = 2;

  // enum SetMode
  const SetMode_Insert = 0;
  const SetMode_Delete = 1;

  // enum ConfigWindow
  const ConfigWindow_X = 1;
  const ConfigWindow_Y = 2;
  const ConfigWindow_Width = 4;
  const ConfigWindow_Height = 8;
  const ConfigWindow_BorderWidth = 16;
  const ConfigWindow_Sibling = 32;
  const ConfigWindow_StackMode = 64;

  // enum StackMode
  const StackMode_Above = 0;
  const StackMode_Below = 1;
  const StackMode_TopIf = 2;
  const StackMode_BottomIf = 3;
  const StackMode_Opposite = 4;

  // enum Circulate
  const Circulate_RaiseLowest = 0;
  const Circulate_LowerHighest = 1;

  // enum PropMode
  const PropMode_Replace = 0;
  const PropMode_Prepend = 1;
  const PropMode_Append = 2;

  // enum GetPropertyType
  const GetPropertyType_Any = 0;

  // enum SendEventDest
  const SendEventDest_PointerWindow = 0;
  const SendEventDest_ItemFocus = 1;

  // enum GrabMode
  const GrabMode_Sync = 0;
  const GrabMode_Async = 1;

  // enum GrabStatus
  const GrabStatus_Success = 0;
  const GrabStatus_AlreadyGrabbed = 1;
  const GrabStatus_InvalidTime = 2;
  const GrabStatus_NotViewable = 3;
  const GrabStatus_Frozen = 4;

  // enum Cursor
  const Cursor_None = 0;

  // enum ButtonIndex
  const ButtonIndex_Any = 0;
  const ButtonIndex_1 = 1;
  const ButtonIndex_2 = 2;
  const ButtonIndex_3 = 3;
  const ButtonIndex_4 = 4;
  const ButtonIndex_5 = 5;

  // enum Grab
  const Grab_Any = 0;

  // enum Allow
  const Allow_AsyncPointer = 0;
  const Allow_SyncPointer = 1;
  const Allow_ReplayPointer = 2;
  const Allow_AsyncKeyboard = 3;
  const Allow_SyncKeyboard = 4;
  const Allow_ReplayKeyboard = 5;
  const Allow_AsyncBoth = 6;
  const Allow_SyncBoth = 7;

  // enum InputFocus
  const InputFocus_None = 0;
  const InputFocus_PointerRoot = 1;
  const InputFocus_Parent = 2;
  const InputFocus_FollowKeyboard = 3;

  // enum FontDraw
  const FontDraw_LeftToRight = 0;
  const FontDraw_RightToLeft = 1;

  // enum GC
  const GC_Function = 1;
  const GC_PlaneMask = 2;
  const GC_Foreground = 4;
  const GC_Background = 8;
  const GC_LineWidth = 16;
  const GC_LineStyle = 32;
  const GC_CapStyle = 64;
  const GC_JoinStyle = 128;
  const GC_FillStyle = 256;
  const GC_FillRule = 512;
  const GC_Tile = 1024;
  const GC_Stipple = 2048;
  const GC_TileStippleOriginX = 4096;
  const GC_TileStippleOriginY = 8192;
  const GC_Font = 16384;
  const GC_SubwindowMode = 32768;
  const GC_GraphicsExposures = 65536;
  const GC_ClipOriginX = 131072;
  const GC_ClipOriginY = 262144;
  const GC_ClipMask = 524288;
  const GC_DashOffset = 1048576;
  const GC_DashList = 2097152;
  const GC_ArcMode = 4194304;

  // enum GX
  const GX_clear = 0;
  const GX_and = 1;
  const GX_andReverse = 2;
  const GX_copy = 3;
  const GX_andInverted = 4;
  const GX_noop = 5;
  const GX_xor = 6;
  const GX_or = 7;
  const GX_nor = 8;
  const GX_equiv = 9;
  const GX_invert = 10;
  const GX_orReverse = 11;
  const GX_copyInverted = 12;
  const GX_orInverted = 13;
  const GX_nand = 14;
  const GX_set = 15;

  // enum LineStyle
  const LineStyle_Solid = 0;
  const LineStyle_OnOffDash = 1;
  const LineStyle_DoubleDash = 2;

  // enum CapStyle
  const CapStyle_NotLast = 0;
  const CapStyle_Butt = 1;
  const CapStyle_Round = 2;
  const CapStyle_Projecting = 3;

  // enum JoinStyle
  const JoinStyle_Miter = 0;
  const JoinStyle_Round = 1;
  const JoinStyle_Bevel = 2;

  // enum FillStyle
  const FillStyle_Solid = 0;
  const FillStyle_Tiled = 1;
  const FillStyle_Stippled = 2;
  const FillStyle_OpaqueStippled = 3;

  // enum FillRule
  const FillRule_EvenOdd = 0;
  const FillRule_Winding = 1;

  // enum SubwindowMode
  const SubwindowMode_ClipByChildren = 0;
  const SubwindowMode_IncludeInferiors = 1;

  // enum ArcMode
  const ArcMode_Chord = 0;
  const ArcMode_PieSlice = 1;

  // enum ClipOrdering
  const ClipOrdering_Unsorted = 0;
  const ClipOrdering_YSorted = 1;
  const ClipOrdering_YXSorted = 2;
  const ClipOrdering_YXBanded = 3;

  // enum CoordMode
  const CoordMode_Origin = 0;
  const CoordMode_Previous = 1;

  // enum PolyShape
  const PolyShape_Complex = 0;
  const PolyShape_Nonconvex = 1;
  const PolyShape_Convex = 2;

  // enum ImageFormat
  const ImageFormat_XYBitmap = 0;
  const ImageFormat_XYPixmap = 1;
  const ImageFormat_ZPixmap = 2;

  // enum ColormapAlloc
  const ColormapAlloc_None = 0;
  const ColormapAlloc_All = 1;

  // enum ColorFlag
  const ColorFlag_Red = 1;
  const ColorFlag_Green = 2;
  const ColorFlag_Blue = 4;

  // enum Pixmap
  const Pixmap_None = 0;

  // enum Font
  const Font_None = 0;

  // enum QueryShapeOf
  const QueryShapeOf_LargestCursor = 0;
  const QueryShapeOf_FastestTile = 1;
  const QueryShapeOf_FastestStipple = 2;

  // enum KB
  const KB_KeyClickPercent = 1;
  const KB_BellPercent = 2;
  const KB_BellPitch = 4;
  const KB_BellDuration = 8;
  const KB_Led = 16;
  const KB_LedMode = 32;
  const KB_Key = 64;
  const KB_AutoRepeatMode = 128;

  // enum LedMode
  const LedMode_Off = 0;
  const LedMode_On = 1;

  // enum AutoRepeatMode
  const AutoRepeatMode_Off = 0;
  const AutoRepeatMode_On = 1;
  const AutoRepeatMode_Default = 2;

  // enum Blanking
  const Blanking_NotPreferred = 0;
  const Blanking_Preferred = 1;
  const Blanking_Default = 2;

  // enum Exposures
  const Exposures_NotAllowed = 0;
  const Exposures_Allowed = 1;
  const Exposures_Default = 2;

  // enum HostMode
  const HostMode_Insert = 0;
  const HostMode_Delete = 1;

  // enum Family
  const Family_Internet = 0;
  const Family_DECnet = 1;
  const Family_Chaos = 2;
  const Family_ServerInterpreted = 5;
  const Family_Internet6 = 6;

  // enum AccessControl
  const AccessControl_Disable = 0;
  const AccessControl_Enable = 1;

  // enum CloseDown
  const CloseDown_DestroyAll = 0;
  const CloseDown_RetainPermanent = 1;
  const CloseDown_RetainTemporary = 2;

  // enum Kill
  const Kill_AllTemporary = 0;

  // enum ScreenSaver
  const ScreenSaver_Reset = 0;
  const ScreenSaver_Active = 1;

  // enum MappingStatus
  const MappingStatus_Success = 0;
  const MappingStatus_Busy = 1;
  const MappingStatus_Failure = 2;

  // enum MapIndex
  const MapIndex_Shift = 0;
  const MapIndex_Lock = 1;
  const MapIndex_Control = 2;
  const MapIndex_1 = 3;
  const MapIndex_2 = 4;
  const MapIndex_3 = 5;
  const MapIndex_4 = 6;
  const MapIndex_5 = 7;

  // struct CHAR2B
  type
    TCHAR2B_Struct = packed record
      byte1: cuint8;
      byte2: cuint8;
    end;

  // struct POINT
  type
    TPOINT_Struct = packed record
      x: cint16;
      y: cint16;
    end;

  // struct RECTANGLE
  type
    TRECTANGLE_Struct = packed record
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
    end;

  // struct ARC
  type
    TARC_Struct = packed record
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
      angle1: cint16;
      angle2: cint16;
    end;

  // struct FORMAT
  type
    TFORMAT_Struct = packed record
      depth: cuint8;
      bits_per_pixel: cuint8;
      scanline_pad: cuint8;
      pad_3: array[0..5-1] of cuint8; // padding
    end;

  // struct VISUALTYPE
  type
    TVISUALTYPE_Struct = packed record
      visual_id: TVISUALID;
      _class: cuint8;
      bits_per_rgb_value: cuint8;
      colormap_entries: cuint16;
      red_mask: cuint32;
      green_mask: cuint32;
      blue_mask: cuint32;
      pad_7: array[0..4-1] of cuint8; // padding
    end;

  // struct DEPTH
  type
    TDEPTH_Struct = packed record
      depth: cuint8;
      pad_1: array[0..1-1] of cuint8; // padding
      visuals_len: cuint16;
      pad_3: array[0..4-1] of cuint8; // padding
      list_4: Pointer; // list field
    end;

  // struct SCREEN
  type
    TSCREEN_Struct = packed record
      root: TWINDOW;
      default_colormap: TCOLORMAP;
      white_pixel: cuint32;
      black_pixel: cuint32;
      current_input_masks: cuint32;
      width_in_pixels: cuint16;
      height_in_pixels: cuint16;
      width_in_millimeters: cuint16;
      height_in_millimeters: cuint16;
      min_installed_maps: cuint16;
      max_installed_maps: cuint16;
      root_visual: TVISUALID;
      backing_stores: cuint8;
      save_unders: cuint8;
      root_depth: cuint8;
      allowed_depths_len: cuint8;
      list_16: Pointer; // list field
    end;

  // struct SetupRequest
  type
    TSetupRequest_Struct = packed record
      byte_order: cuint8;
      pad_1: array[0..1-1] of cuint8; // padding
      protocol_major_version: cuint16;
      protocol_minor_version: cuint16;
      authorization_protocol_name_len: cuint16;
      authorization_protocol_data_len: cuint16;
      pad_6: array[0..2-1] of cuint8; // padding
      list_7: Pointer; // list field
      pad_8: cuint8; // pad (unspecified bytes)
      list_9: Pointer; // list field
      pad_10: cuint8; // pad (unspecified bytes)
    end;

  // struct SetupFailed
  type
    TSetupFailed_Struct = packed record
      status: cuint8;
      // #comment (node index 1) - skipped
      reason_len: cuint8;
      protocol_major_version: cuint16;
      protocol_minor_version: cuint16;
      length: cuint16;
      list_6: Pointer; // list field
    end;

  // struct SetupAuthenticate
  type
    TSetupAuthenticate_Struct = packed record
      status: cuint8;
      // #comment (node index 1) - skipped
      pad_2: array[0..5-1] of cuint8; // padding
      length: cuint16;
      list_4: Pointer; // list field
    end;

  // struct Setup
  type
    TSetup_Struct = packed record
      status: cuint8;
      // #comment (node index 1) - skipped
      pad_2: array[0..1-1] of cuint8; // padding
      protocol_major_version: cuint16;
      protocol_minor_version: cuint16;
      length: cuint16;
      release_number: cuint32;
      resource_id_base: cuint32;
      resource_id_mask: cuint32;
      motion_buffer_size: cuint32;
      vendor_len: cuint16;
      maximum_request_length: cuint16;
      roots_len: cuint8;
      pixmap_formats_len: cuint8;
      image_byte_order: cuint8;
      bitmap_format_bit_order: cuint8;
      bitmap_format_scanline_unit: cuint8;
      bitmap_format_scanline_pad: cuint8;
      min_keycode: TKEYCODE;
      max_keycode: TKEYCODE;
      pad_20: array[0..4-1] of cuint8; // padding
      list_21: Pointer; // list field
      pad_22: cuint8; // pad (unspecified bytes)
      list_23: Pointer; // list field
      list_24: Pointer; // list field
    end;

  // struct TIMECOORD
  type
    TTIMECOORD_Struct = packed record
      time: TTIMESTAMP;
      x: cint16;
      y: cint16;
    end;

  // struct FONTPROP
  type
    TFONTPROP_Struct = packed record
      name: TATOM;
      value: cuint32;
    end;

  // struct CHARINFO
  type
    TCHARINFO_Struct = packed record
      left_side_bearing: cint16;
      right_side_bearing: cint16;
      character_width: cint16;
      ascent: cint16;
      descent: cint16;
      attributes: cuint16;
    end;

  // struct STR
  type
    TSTR_Struct = packed record
      name_len: cuint8;
      list_1: Pointer; // list field
    end;

  // struct SEGMENT
  type
    TSEGMENT_Struct = packed record
      x1: cint16;
      y1: cint16;
      x2: cint16;
      y2: cint16;
    end;

  // struct COLORITEM
  type
    TCOLORITEM_Struct = packed record
      pixel: cuint32;
      red: cuint16;
      green: cuint16;
      blue: cuint16;
      flags: cuint8;
      pad_5: array[0..1-1] of cuint8; // padding
    end;

  // struct RGB
  type
    TRGB_Struct = packed record
      red: cuint16;
      green: cuint16;
      blue: cuint16;
      pad_3: array[0..2-1] of cuint8; // padding
    end;

  // struct HOST
  type
    THOST_Struct = packed record
      family: cuint8;
      pad_1: array[0..1-1] of cuint8; // padding
      address_len: cuint16;
      list_3: Pointer; // list field
      pad_4: cuint8; // pad (unspecified bytes)
    end;

  // union ClientMessageData
  type
    TClientMessageData_Union = packed record
      case Integer of
        1: (data8: array[0..20-1] of cuint8);
        3: (data16: array[0..10-1] of cuint16);
        5: (data32: array[0..5-1] of cuint32);
    end;

  // event KeyPress
  type
    TKeyPress_Event = packed record
      detail: TKEYCODE;
      time: TTIMESTAMP;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: cint16;
      root_y: cint16;
      event_x: cint16;
      event_y: cint16;
      state: cuint16;
      same_screen: cuint8;
    end;

  // event ButtonPress
  type
    TButtonPress_Event = packed record
      detail: TBUTTON;
      time: TTIMESTAMP;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: cint16;
      root_y: cint16;
      event_x: cint16;
      event_y: cint16;
      state: cuint16;
      same_screen: cuint8;
    end;

  // event MotionNotify
  type
    TMotionNotify_Event = packed record
      detail: cuint8;
      time: TTIMESTAMP;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: cint16;
      root_y: cint16;
      event_x: cint16;
      event_y: cint16;
      state: cuint16;
      same_screen: cuint8;
    end;

  // event EnterNotify
  type
    TEnterNotify_Event = packed record
      detail: cuint8;
      time: TTIMESTAMP;
      root: TWINDOW;
      event: TWINDOW;
      child: TWINDOW;
      root_x: cint16;
      root_y: cint16;
      event_x: cint16;
      event_y: cint16;
      state: cuint16;
      mode: cuint8;
      same_screen_focus: cuint8;
    end;

  // event FocusIn
  type
    TFocusIn_Event = packed record
      detail: cuint8;
      event: TWINDOW;
      mode: cuint8;
    end;

  // event KeymapNotify
  type
    TKeymapNotify_Event = packed record
    end;

  // event Expose
  type
    TExpose_Event = packed record
      window: TWINDOW;
      x: cuint16;
      y: cuint16;
      width: cuint16;
      height: cuint16;
      count: cuint16;
    end;

  // event GraphicsExposure
  type
    TGraphicsExposure_Event = packed record
      drawable: cuint32;
      x: cuint16;
      y: cuint16;
      width: cuint16;
      height: cuint16;
      minor_opcode: cuint16;
      count: cuint16;
      major_opcode: cuint8;
    end;

  // event NoExposure
  type
    TNoExposure_Event = packed record
      drawable: cuint32;
      minor_opcode: cuint16;
      major_opcode: cuint8;
    end;

  // event VisibilityNotify
  type
    TVisibilityNotify_Event = packed record
      window: TWINDOW;
      state: cuint8;
    end;

  // event CreateNotify
  type
    TCreateNotify_Event = packed record
      parent: TWINDOW;
      window: TWINDOW;
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
      border_width: cuint16;
      override_redirect: cuint8;
    end;

  // event DestroyNotify
  type
    TDestroyNotify_Event = packed record
      event: TWINDOW;
      window: TWINDOW;
    end;

  // event UnmapNotify
  type
    TUnmapNotify_Event = packed record
      event: TWINDOW;
      window: TWINDOW;
      from_configure: cuint8;
    end;

  // event MapNotify
  type
    TMapNotify_Event = packed record
      event: TWINDOW;
      window: TWINDOW;
      override_redirect: cuint8;
    end;

  // event MapRequest
  type
    TMapRequest_Event = packed record
      parent: TWINDOW;
      window: TWINDOW;
    end;

  // event ReparentNotify
  type
    TReparentNotify_Event = packed record
      event: TWINDOW;
      window: TWINDOW;
      parent: TWINDOW;
      x: cint16;
      y: cint16;
      override_redirect: cuint8;
    end;

  // event ConfigureNotify
  type
    TConfigureNotify_Event = packed record
      event: TWINDOW;
      window: TWINDOW;
      above_sibling: TWINDOW;
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
      border_width: cuint16;
      override_redirect: cuint8;
    end;

  // event ConfigureRequest
  type
    TConfigureRequest_Event = packed record
      stack_mode: cuint8;
      parent: TWINDOW;
      window: TWINDOW;
      sibling: TWINDOW;
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
      border_width: cuint16;
      value_mask: cuint16;
    end;

  // event GravityNotify
  type
    TGravityNotify_Event = packed record
      event: TWINDOW;
      window: TWINDOW;
      x: cint16;
      y: cint16;
    end;

  // event ResizeRequest
  type
    TResizeRequest_Event = packed record
      window: TWINDOW;
      width: cuint16;
      height: cuint16;
    end;

  // event CirculateNotify
  type
    TCirculateNotify_Event = packed record
      event: TWINDOW;
      window: TWINDOW;
      place: cuint8;
    end;

  // event PropertyNotify
  type
    TPropertyNotify_Event = packed record
      window: TWINDOW;
      atom: TATOM;
      time: TTIMESTAMP;
      state: cuint8;
    end;

  // event SelectionClear
  type
    TSelectionClear_Event = packed record
      time: TTIMESTAMP;
      owner: TWINDOW;
      selection: TATOM;
    end;

  // event SelectionRequest
  type
    TSelectionRequest_Event = packed record
      time: TTIMESTAMP;
      owner: TWINDOW;
      requestor: TWINDOW;
      selection: TATOM;
      target: TATOM;
      _property: TATOM;
    end;

  // event SelectionNotify
  type
    TSelectionNotify_Event = packed record
      time: TTIMESTAMP;
      requestor: TWINDOW;
      selection: TATOM;
      target: TATOM;
      _property: TATOM;
    end;

  // event ColormapNotify
  type
    TColormapNotify_Event = packed record
      window: TWINDOW;
      colormap: TCOLORMAP;
      new: cuint8;
      state: cuint8;
    end;

  // event ClientMessage
  type
    TClientMessage_Event = packed record
      format: cuint8;
      window: TWINDOW;
      _type: TATOM;
      data: TClientMessageData;
    end;

  // event MappingNotify
  type
    TMappingNotify_Event = packed record
      request: cuint8;
      first_keycode: TKEYCODE;
      count: cuint8;
    end;

  // event GeGeneric
  type
    TGeGeneric_Event = packed record
    end;

  // error Request
  type
    TRequest_Error = packed record
      bad_value: cuint32;
      minor_opcode: cuint16;
      major_opcode: cuint8;
    end;

  // error Value
  type
    TValue_Error = packed record
      bad_value: cuint32;
      minor_opcode: cuint16;
      major_opcode: cuint8;
    end;

  // request CreateWindow
  const XCB_CREATEWINDOW = 1; // opcode
  // request ChangeWindowAttributes
  const XCB_CHANGEWINDOWATTRIBUTES = 2; // opcode
  // request GetWindowAttributes
  const XCB_GETWINDOWATTRIBUTES = 3; // opcode
  type
    TGetWindowAttributesReply = packed record
      backing_store: cuint8;
      visual: TVISUALID;
      _class: cuint16;
      bit_gravity: cuint8;
      win_gravity: cuint8;
      backing_planes: cuint32;
      backing_pixel: cuint32;
      save_under: cuint8;
      map_is_installed: cuint8;
      map_state: cuint8;
      override_redirect: cuint8;
      colormap: TCOLORMAP;
      all_event_masks: cuint32;
      your_event_mask: cuint32;
      do_not_propagate_mask: cuint16;
    end;

  // request DestroyWindow
  const XCB_DESTROYWINDOW = 4; // opcode
  // request DestroySubwindows
  const XCB_DESTROYSUBWINDOWS = 5; // opcode
  // request ChangeSaveSet
  const XCB_CHANGESAVESET = 6; // opcode
  // request ReparentWindow
  const XCB_REPARENTWINDOW = 7; // opcode
  // request MapWindow
  const XCB_MAPWINDOW = 8; // opcode
  // request MapSubwindows
  const XCB_MAPSUBWINDOWS = 9; // opcode
  // request UnmapWindow
  const XCB_UNMAPWINDOW = 10; // opcode
  // request UnmapSubwindows
  const XCB_UNMAPSUBWINDOWS = 11; // opcode
  // request ConfigureWindow
  const XCB_CONFIGUREWINDOW = 12; // opcode
  // request CirculateWindow
  const XCB_CIRCULATEWINDOW = 13; // opcode
  // request GetGeometry
  const XCB_GETGEOMETRY = 14; // opcode
  type
    TGetGeometryReply = packed record
      depth: cuint8;
      root: TWINDOW;
      x: cint16;
      y: cint16;
      width: cuint16;
      height: cuint16;
      border_width: cuint16;
    end;

  // request QueryTree
  const XCB_QUERYTREE = 15; // opcode
  type
    TQueryTreeReply = packed record
      root: TWINDOW;
      parent: TWINDOW;
      children_len: cuint16;
    end;

  // request InternAtom
  const XCB_INTERNATOM = 16; // opcode
  type
    TInternAtomReply = packed record
      atom: TATOM;
    end;

  // request GetAtomName
  const XCB_GETATOMNAME = 17; // opcode
  type
    TGetAtomNameReply = packed record
      name_len: cuint16;
    end;

  // request ChangeProperty
  const XCB_CHANGEPROPERTY = 18; // opcode
  // request DeleteProperty
  const XCB_DELETEPROPERTY = 19; // opcode
  // request GetProperty
  const XCB_GETPROPERTY = 20; // opcode
  type
    TGetPropertyReply = packed record
      format: cuint8;
      _type: TATOM;
      bytes_after: cuint32;
      value_len: cuint32;
    end;

  // request ListProperties
  const XCB_LISTPROPERTIES = 21; // opcode
  type
    TListPropertiesReply = packed record
      atoms_len: cuint16;
    end;

  // request SetSelectionOwner
  const XCB_SETSELECTIONOWNER = 22; // opcode
  // request GetSelectionOwner
  const XCB_GETSELECTIONOWNER = 23; // opcode
  type
    TGetSelectionOwnerReply = packed record
      owner: TWINDOW;
    end;

  // request ConvertSelection
  const XCB_CONVERTSELECTION = 24; // opcode
  // request SendEvent
  const XCB_SENDEVENT = 25; // opcode
  // request GrabPointer
  const XCB_GRABPOINTER = 26; // opcode
  type
    TGrabPointerReply = packed record
      status: cuint8;
    end;

  // request UngrabPointer
  const XCB_UNGRABPOINTER = 27; // opcode
  // request GrabButton
  const XCB_GRABBUTTON = 28; // opcode
  // request UngrabButton
  const XCB_UNGRABBUTTON = 29; // opcode
  // request ChangeActivePointerGrab
  const XCB_CHANGEACTIVEPOINTERGRAB = 30; // opcode
  // request GrabKeyboard
  const XCB_GRABKEYBOARD = 31; // opcode
  type
    TGrabKeyboardReply = packed record
      status: cuint8;
    end;

  // request UngrabKeyboard
  const XCB_UNGRABKEYBOARD = 32; // opcode
  // request GrabKey
  const XCB_GRABKEY = 33; // opcode
  // request UngrabKey
  const XCB_UNGRABKEY = 34; // opcode
  // request AllowEvents
  const XCB_ALLOWEVENTS = 35; // opcode
  // request GrabServer
  const XCB_GRABSERVER = 36; // opcode
  // request UngrabServer
  const XCB_UNGRABSERVER = 37; // opcode
  // request QueryPointer
  const XCB_QUERYPOINTER = 38; // opcode
  type
    TQueryPointerReply = packed record
      same_screen: cuint8;
      root: TWINDOW;
      child: TWINDOW;
      root_x: cint16;
      root_y: cint16;
      win_x: cint16;
      win_y: cint16;
      mask: cuint16;
    end;

  // request GetMotionEvents
  const XCB_GETMOTIONEVENTS = 39; // opcode
  type
    TGetMotionEventsReply = packed record
      events_len: cuint32;
    end;

  // request TranslateCoordinates
  const XCB_TRANSLATECOORDINATES = 40; // opcode
  type
    TTranslateCoordinatesReply = packed record
      same_screen: cuint8;
      child: TWINDOW;
      dst_x: cint16;
      dst_y: cint16;
    end;

  // request WarpPointer
  const XCB_WARPPOINTER = 41; // opcode
  // request SetInputFocus
  const XCB_SETINPUTFOCUS = 42; // opcode
  // request GetInputFocus
  const XCB_GETINPUTFOCUS = 43; // opcode
  type
    TGetInputFocusReply = packed record
      revert_to: cuint8;
      focus: TWINDOW;
    end;

  // request QueryKeymap
  const XCB_QUERYKEYMAP = 44; // opcode
  type
    TQueryKeymapReply = packed record
    end;

  // request OpenFont
  const XCB_OPENFONT = 45; // opcode
  // request CloseFont
  const XCB_CLOSEFONT = 46; // opcode
  // request QueryFont
  const XCB_QUERYFONT = 47; // opcode
  type
    TQueryFontReply = packed record
      min_bounds: cuint32;
      max_bounds: cuint32;
      min_char_or_byte2: cuint16;
      max_char_or_byte2: cuint16;
      default_char: cuint16;
      properties_len: cuint16;
      draw_direction: cuint8;
      min_byte1: cuint8;
      max_byte1: cuint8;
      all_chars_exist: cuint8;
      font_ascent: cint16;
      font_descent: cint16;
      char_infos_len: cuint32;
    end;

  // request QueryTextExtents
  const XCB_QUERYTEXTEXTENTS = 48; // opcode
  type
    TQueryTextExtentsReply = packed record
      draw_direction: cuint8;
      font_ascent: cint16;
      font_descent: cint16;
      overall_ascent: cint16;
      overall_descent: cint16;
      overall_width: cint32;
      overall_left: cint32;
      overall_right: cint32;
    end;

  // request ListFonts
  const XCB_LISTFONTS = 49; // opcode
  type
    TListFontsReply = packed record
      names_len: cuint16;
    end;

  // request ListFontsWithInfo
  const XCB_LISTFONTSWITHINFO = 50; // opcode
  type
    TListFontsWithInfoReply = packed record
      name_len: cuint8;
      min_bounds: cuint32;
      max_bounds: cuint32;
      min_char_or_byte2: cuint16;
      max_char_or_byte2: cuint16;
      default_char: cuint16;
      properties_len: cuint16;
      draw_direction: cuint8;
      min_byte1: cuint8;
      max_byte1: cuint8;
      all_chars_exist: cuint8;
      font_ascent: cint16;
      font_descent: cint16;
      replies_hint: cuint32;
    end;

  // request SetFontPath
  const XCB_SETFONTPATH = 51; // opcode
  // request GetFontPath
  const XCB_GETFONTPATH = 52; // opcode
  type
    TGetFontPathReply = packed record
      path_len: cuint16;
    end;

  // request CreatePixmap
  const XCB_CREATEPIXMAP = 53; // opcode
  // request FreePixmap
  const XCB_FREEPIXMAP = 54; // opcode
  // request CreateGC
  const XCB_CREATEGC = 55; // opcode
  // request ChangeGC
  const XCB_CHANGEGC = 56; // opcode
  // request CopyGC
  const XCB_COPYGC = 57; // opcode
  // request SetDashes
  const XCB_SETDASHES = 58; // opcode
  // request SetClipRectangles
  const XCB_SETCLIPRECTANGLES = 59; // opcode
  // request FreeGC
  const XCB_FREEGC = 60; // opcode
  // request ClearArea
  const XCB_CLEARAREA = 61; // opcode
  // request CopyArea
  const XCB_COPYAREA = 62; // opcode
  // request CopyPlane
  const XCB_COPYPLANE = 63; // opcode
  // request PolyPoint
  const XCB_POLYPOINT = 64; // opcode
  // request PolyLine
  const XCB_POLYLINE = 65; // opcode
  // request PolySegment
  const XCB_POLYSEGMENT = 66; // opcode
  // request PolyRectangle
  const XCB_POLYRECTANGLE = 67; // opcode
  // request PolyArc
  const XCB_POLYARC = 68; // opcode
  // request FillPoly
  const XCB_FILLPOLY = 69; // opcode
  // request PolyFillRectangle
  const XCB_POLYFILLRECTANGLE = 70; // opcode
  // request PolyFillArc
  const XCB_POLYFILLARC = 71; // opcode
  // request PutImage
  const XCB_PUTIMAGE = 72; // opcode
  // request GetImage
  const XCB_GETIMAGE = 73; // opcode
  type
    TGetImageReply = packed record
      depth: cuint8;
      visual: TVISUALID;
    end;

  // request PolyText8
  const XCB_POLYTEXT8 = 74; // opcode
  // request PolyText16
  const XCB_POLYTEXT16 = 75; // opcode
  // request ImageText8
  const XCB_IMAGETEXT8 = 76; // opcode
  // request ImageText16
  const XCB_IMAGETEXT16 = 77; // opcode
  // request CreateColormap
  const XCB_CREATECOLORMAP = 78; // opcode
  // request FreeColormap
  const XCB_FREECOLORMAP = 79; // opcode
  // request CopyColormapAndFree
  const XCB_COPYCOLORMAPANDFREE = 80; // opcode
  // request InstallColormap
  const XCB_INSTALLCOLORMAP = 81; // opcode
  // request UninstallColormap
  const XCB_UNINSTALLCOLORMAP = 82; // opcode
  // request ListInstalledColormaps
  const XCB_LISTINSTALLEDCOLORMAPS = 83; // opcode
  type
    TListInstalledColormapsReply = packed record
      cmaps_len: cuint16;
    end;

  // request AllocColor
  const XCB_ALLOCCOLOR = 84; // opcode
  type
    TAllocColorReply = packed record
      red: cuint16;
      green: cuint16;
      blue: cuint16;
      pixel: cuint32;
    end;

  // request AllocNamedColor
  const XCB_ALLOCNAMEDCOLOR = 85; // opcode
  type
    TAllocNamedColorReply = packed record
      pixel: cuint32;
      exact_red: cuint16;
      exact_green: cuint16;
      exact_blue: cuint16;
      visual_red: cuint16;
      visual_green: cuint16;
      visual_blue: cuint16;
    end;

  // request AllocColorCells
  const XCB_ALLOCCOLORCELLS = 86; // opcode
  type
    TAllocColorCellsReply = packed record
      pixels_len: cuint16;
      masks_len: cuint16;
    end;

  // request AllocColorPlanes
  const XCB_ALLOCCOLORPLANES = 87; // opcode
  type
    TAllocColorPlanesReply = packed record
      pixels_len: cuint16;
      red_mask: cuint32;
      green_mask: cuint32;
      blue_mask: cuint32;
    end;

  // request FreeColors
  const XCB_FREECOLORS = 88; // opcode
  // request StoreColors
  const XCB_STORECOLORS = 89; // opcode
  // request StoreNamedColor
  const XCB_STORENAMEDCOLOR = 90; // opcode
  // request QueryColors
  const XCB_QUERYCOLORS = 91; // opcode
  type
    TQueryColorsReply = packed record
      colors_len: cuint16;
    end;

  // request LookupColor
  const XCB_LOOKUPCOLOR = 92; // opcode
  type
    TLookupColorReply = packed record
      exact_red: cuint16;
      exact_green: cuint16;
      exact_blue: cuint16;
      visual_red: cuint16;
      visual_green: cuint16;
      visual_blue: cuint16;
    end;

  // request CreateCursor
  const XCB_CREATECURSOR = 93; // opcode
  // request CreateGlyphCursor
  const XCB_CREATEGLYPHCURSOR = 94; // opcode
  // request FreeCursor
  const XCB_FREECURSOR = 95; // opcode
  // request RecolorCursor
  const XCB_RECOLORCURSOR = 96; // opcode
  // request QueryBestSize
  const XCB_QUERYBESTSIZE = 97; // opcode
  type
    TQueryBestSizeReply = packed record
      width: cuint16;
      height: cuint16;
    end;

  // request QueryExtension
  const XCB_QUERYEXTENSION = 98; // opcode
  type
    TQueryExtensionReply = packed record
      present: cuint8;
      major_opcode: cuint8;
      first_event: cuint8;
      first_error: cuint8;
    end;

  // request ListExtensions
  const XCB_LISTEXTENSIONS = 99; // opcode
  type
    TListExtensionsReply = packed record
      names_len: cuint8;
    end;

  // request ChangeKeyboardMapping
  const XCB_CHANGEKEYBOARDMAPPING = 100; // opcode
  // request GetKeyboardMapping
  const XCB_GETKEYBOARDMAPPING = 101; // opcode
  type
    TGetKeyboardMappingReply = packed record
      keysyms_per_keycode: cuint8;
    end;

  // request ChangeKeyboardControl
  const XCB_CHANGEKEYBOARDCONTROL = 102; // opcode
  // request GetKeyboardControl
  const XCB_GETKEYBOARDCONTROL = 103; // opcode
  type
    TGetKeyboardControlReply = packed record
      global_auto_repeat: cuint8;
      led_mask: cuint32;
      key_click_percent: cuint8;
      bell_percent: cuint8;
      bell_pitch: cuint16;
      bell_duration: cuint16;
    end;

  // request Bell
  const XCB_BELL = 104; // opcode
  // request ChangePointerControl
  const XCB_CHANGEPOINTERCONTROL = 105; // opcode
  // request GetPointerControl
  const XCB_GETPOINTERCONTROL = 106; // opcode
  type
    TGetPointerControlReply = packed record
      acceleration_numerator: cuint16;
      acceleration_denominator: cuint16;
      threshold: cuint16;
    end;

  // request SetScreenSaver
  const XCB_SETSCREENSAVER = 107; // opcode
  // request GetScreenSaver
  const XCB_GETSCREENSAVER = 108; // opcode
  type
    TGetScreenSaverReply = packed record
      timeout: cuint16;
      interval: cuint16;
      prefer_blanking: cuint8;
      allow_exposures: cuint8;
    end;

  // request ChangeHosts
  const XCB_CHANGEHOSTS = 109; // opcode
  // request ListHosts
  const XCB_LISTHOSTS = 110; // opcode
  type
    TListHostsReply = packed record
      mode: cuint8;
      hosts_len: cuint16;
    end;

  // request SetAccessControl
  const XCB_SETACCESSCONTROL = 111; // opcode
  // request SetCloseDownMode
  const XCB_SETCLOSEDOWNMODE = 112; // opcode
  // request KillClient
  const XCB_KILLCLIENT = 113; // opcode
  // request RotateProperties
  const XCB_ROTATEPROPERTIES = 114; // opcode
  // request ForceScreenSaver
  const XCB_FORCESCREENSAVER = 115; // opcode
  // request SetPointerMapping
  const XCB_SETPOINTERMAPPING = 116; // opcode
  type
    TSetPointerMappingReply = packed record
      status: cuint8;
    end;

  // request GetPointerMapping
  const XCB_GETPOINTERMAPPING = 117; // opcode
  type
    TGetPointerMappingReply = packed record
      map_len: cuint8;
    end;

  // request SetModifierMapping
  const XCB_SETMODIFIERMAPPING = 118; // opcode
  type
    TSetModifierMappingReply = packed record
      status: cuint8;
    end;

  // request GetModifierMapping
  const XCB_GETMODIFIERMAPPING = 119; // opcode
  type
    TGetModifierMappingReply = packed record
      keycodes_per_modifier: cuint8;
    end;

  // request NoOperation
  const XCB_NOOPERATION = 127; // opcode

implementation

end.
