unit xv;

{$mode objfpc}{$H+}

interface

uses
  ctypes, xcb;

  // Auto-generated from xv.xml
  // Pure 1:1 C binding skeleton for FreePascal (packed records, consts).

  // xidtype PORT
  type TPORT = cuint32;

  // xidtype ENCODING
  type TENCODING = cuint32;

  // enum Type
  const Type_InputMask = 1;
  const Type_OutputMask = 2;
  const Type_VideoMask = 4;
  const Type_StillMask = 8;
  const Type_ImageMask = 16;

  // enum ImageFormatInfoType
  const ImageFormatInfoType_RGB = 0;
  const ImageFormatInfoType_YUV = 1;

  // enum ImageFormatInfoFormat
  const ImageFormatInfoFormat_Packed = 0;
  const ImageFormatInfoFormat_Planar = 1;

  // enum AttributeFlag
  const AttributeFlag_Gettable = 1;
  const AttributeFlag_Settable = 2;

  // enum VideoNotifyReason
  const VideoNotifyReason_Started = 0;
  const VideoNotifyReason_Stopped = 1;
  const VideoNotifyReason_Busy = 2;
  const VideoNotifyReason_Preempted = 3;
  const VideoNotifyReason_HardError = 4;

  // enum ScanlineOrder
  const ScanlineOrder_TopToBottom = 0;
  const ScanlineOrder_BottomToTop = 1;

  // enum GrabPortStatus
  const GrabPortStatus_Success = 0;
  const GrabPortStatus_BadExtension = 1;
  const GrabPortStatus_AlreadyGrabbed = 2;
  const GrabPortStatus_InvalidTime = 3;
  const GrabPortStatus_BadReply = 4;
  const GrabPortStatus_BadAlloc = 5;

  // struct Rational
  type
    TRational_Struct = packed record
      numerator: cint32;
      denominator: cint32;
    end;

  // struct Format
  type
    TFormat_Struct = packed record
      visual: cuint32;
      depth: cuint8;
      pad_2: array[0..3-1] of cuint8; // padding
    end;

  // struct AdaptorInfo
  type
    TAdaptorInfo_Struct = packed record
      base_id: TPORT;
      name_size: cuint16;
      num_ports: cuint16;
      num_formats: cuint16;
      _type: cuint8;
      pad_5: array[0..1-1] of cuint8; // padding
      list_6: Pointer; // list field
      pad_7: cuint8; // pad (unspecified bytes)
      list_8: Pointer; // list field
    end;

  // struct EncodingInfo
  type
    TEncodingInfo_Struct = packed record
      encoding: TENCODING;
      name_size: cuint16;
      width: cuint16;
      height: cuint16;
      pad_4: array[0..2-1] of cuint8; // padding
      rate: cuint32;
      list_6: Pointer; // list field
      pad_7: cuint8; // pad (unspecified bytes)
    end;

  // struct Image
  type
    TImage_Struct = packed record
      id: cuint32;
      width: cuint16;
      height: cuint16;
      data_size: cuint32;
      num_planes: cuint32;
      list_5: Pointer; // list field
      list_6: Pointer; // list field
      list_7: Pointer; // list field
      // #comment (node index 8) - skipped
    end;

  // struct AttributeInfo
  type
    TAttributeInfo_Struct = packed record
      flags: cuint32;
      min: cint32;
      max: cint32;
      size: cuint32;
      list_4: Pointer; // list field
      pad_5: cuint8; // pad (unspecified bytes)
    end;

  // struct ImageFormatInfo
  type
    TImageFormatInfo_Struct = packed record
      id: cuint32;
      _type: cuint8;
      byte_order: cuint8;
      pad_3: array[0..2-1] of cuint8; // padding
      list_4: Pointer; // list field
      bpp: cuint8;
      num_planes: cuint8;
      pad_7: array[0..2-1] of cuint8; // padding
      depth: cuint8;
      pad_9: array[0..3-1] of cuint8; // padding
      red_mask: cuint32;
      green_mask: cuint32;
      blue_mask: cuint32;
      format: cuint8;
      pad_14: array[0..3-1] of cuint8; // padding
      y_sample_bits: cuint32;
      u_sample_bits: cuint32;
      v_sample_bits: cuint32;
      vhorz_y_period: cuint32;
      vhorz_u_period: cuint32;
      vhorz_v_period: cuint32;
      vvert_y_period: cuint32;
      vvert_u_period: cuint32;
      vvert_v_period: cuint32;
      list_24: Pointer; // list field
      vscanline_order: cuint8;
      pad_26: array[0..11-1] of cuint8; // padding
    end;

  // event VideoNotify
  type
    TVideoNotify_Event = packed record
      reason: cuint8;
      time: cuint32;
      drawable: cuint32;
      port: TPORT;
    end;

  // event PortNotify
  type
    TPortNotify_Event = packed record
      time: cuint32;
      port: TPORT;
      attribute: cuint32;
      value: cint32;
    end;

  // error BadPort
  type
    TBadPort_Error = packed record
    end;

  // error BadEncoding
  type
    TBadEncoding_Error = packed record
    end;

  // error BadControl
  type
    TBadControl_Error = packed record
    end;

  // request QueryExtension
  const XCB_QUERYEXTENSION = 0; // opcode
  type
    TQueryExtensionReply = packed record
      major: cuint16;
      minor: cuint16;
    end;

  // request QueryAdaptors
  const XCB_QUERYADAPTORS = 1; // opcode
  type
    TQueryAdaptorsReply = packed record
      num_adaptors: cuint16;
    end;

  // request QueryEncodings
  const XCB_QUERYENCODINGS = 2; // opcode
  type
    TQueryEncodingsReply = packed record
      num_encodings: cuint16;
    end;

  // request GrabPort
  const XCB_GRABPORT = 3; // opcode
  type
    TGrabPortReply = packed record
      result: cuint8;
    end;

  // request UngrabPort
  const XCB_UNGRABPORT = 4; // opcode
  // request PutVideo
  const XCB_PUTVIDEO = 5; // opcode
  // request PutStill
  const XCB_PUTSTILL = 6; // opcode
  // request GetVideo
  const XCB_GETVIDEO = 7; // opcode
  // request GetStill
  const XCB_GETSTILL = 8; // opcode
  // request StopVideo
  const XCB_STOPVIDEO = 9; // opcode
  // request SelectVideoNotify
  const XCB_SELECTVIDEONOTIFY = 10; // opcode
  // request SelectPortNotify
  const XCB_SELECTPORTNOTIFY = 11; // opcode
  // request QueryBestSize
  const XCB_QUERYBESTSIZE = 12; // opcode
  type
    TQueryBestSizeReply = packed record
      actual_width: cuint16;
      actual_height: cuint16;
    end;

  // request SetPortAttribute
  const XCB_SETPORTATTRIBUTE = 13; // opcode
  // request GetPortAttribute
  const XCB_GETPORTATTRIBUTE = 14; // opcode
  type
    TGetPortAttributeReply = packed record
      value: cint32;
    end;

  // request QueryPortAttributes
  const XCB_QUERYPORTATTRIBUTES = 15; // opcode
  type
    TQueryPortAttributesReply = packed record
      num_attributes: cuint32;
      text_size: cuint32;
    end;

  // request ListImageFormats
  const XCB_LISTIMAGEFORMATS = 16; // opcode
  type
    TListImageFormatsReply = packed record
      num_formats: cuint32;
    end;

  // request QueryImageAttributes
  const XCB_QUERYIMAGEATTRIBUTES = 17; // opcode
  type
    TQueryImageAttributesReply = packed record
      num_planes: cuint32;
      data_size: cuint32;
      width: cuint16;
      height: cuint16;
    end;

  // request PutImage
  const XCB_PUTIMAGE = 18; // opcode
  // request ShmPutImage
  const XCB_SHMPUTIMAGE = 19; // opcode

implementation

end.
